/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.rest.AbstractRestHelper;
import com.atlassian.bitbucket.test.rest.RestAuthentication;
import com.google.common.collect.ImmutableMap;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.RequestSpecification;
import com.jayway.restassured.specification.ResponseSpecification;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONUtils;

public class WebHookTestHelper
extends AbstractRestHelper {
    public WebHookTestHelper(String username, String password) {
        super(RestAuthentication.authenticated(username, password));
    }

    public Response create(String name, String callbackUrl, List<String> eventIds, Map<String, String> filters, Response.Status expectedStatus) {
        return (Response)((ResponseSpecification)((RequestSpecification)this.request().log().ifValidationFails()).body(this.createRegistrationBody(name, callbackUrl, filters, eventIds)).expect().statusCode(expectedStatus.getStatusCode()).log().ifValidationFails()).when().post(this.getUrl(), new Object[0]);
    }

    public Response delete(String selfUrl) {
        return (Response)this.request().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(selfUrl, new Object[0]);
    }

    public Response list() {
        return (Response)this.request().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(this.getUrl(), new Object[0]);
    }

    public String getUrl() {
        return String.valueOf(DefaultFuncTestData.getRestURL("webhooks", "latest")) + "/webhook";
    }

    public String getUrl(int id) {
        return String.valueOf(DefaultFuncTestData.getRestURL("webhooks", "latest")) + "/webhook/" + id;
    }

    public String createRegistrationBody(String name, String callbackUrl, Map<String, String> filters, List<String> events) {
        JSONObject json = new JSONObject();
        json.put((Object)"name", (Object)name);
        json.put((Object)"description", (Object)name);
        json.put((Object)"url", (Object)callbackUrl);
        JSONArray jsonEvents = new JSONArray();
        jsonEvents.addAll(events);
        json.put((Object)"events", (Object)jsonEvents);
        JSONObject jsonParams = new JSONObject();
        jsonParams.putAll(filters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> "%s")));
        json.put((Object)"filters", (Object)jsonParams);
        return String.format(json.toString(), filters.entrySet().stream().map(Map.Entry::getValue).map(JSONUtils::quote).map(str -> str.substring(1, str.length() - 1)).toArray());
    }

    public static Map<String, String> filterOnProjectWithId(int id) {
        return ImmutableMap.of((Object)"resource", (Object)WebHookTestHelper.projectFilterEntry(id));
    }

    public static String projectFilterEntry(int id) {
        return "{\"projectId\":\"" + id + "\"}";
    }

    public static Map<String, String> filterOnRepositoryWithId(int id) {
        return ImmutableMap.of((Object)"resource", (Object)WebHookTestHelper.repositoryFilterEntry(id));
    }

    public static String repositoryFilterEntry(int id) {
        return "{\"repositoryId\":\"" + id + "\"}";
    }
}

