/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.mail.MailHostConfiguration;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.project.RestProject;
import com.atlassian.bitbucket.test.BranchTestHelper;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.GroupTestHelper;
import com.atlassian.bitbucket.test.MailServerConfigHelper;
import com.atlassian.bitbucket.test.PermissionsTestHelper;
import com.atlassian.bitbucket.test.ProcessTestHelper;
import com.atlassian.bitbucket.test.ProjectTestHelper;
import com.atlassian.bitbucket.test.PullRequestTestHelper;
import com.atlassian.bitbucket.test.RepositoryTestHelper;
import com.atlassian.bitbucket.test.SshAccessKeysTestHelper;
import com.atlassian.bitbucket.test.SshKeyTestHelper;
import com.atlassian.bitbucket.test.TagTestHelper;
import com.atlassian.bitbucket.test.TaskTestHelper;
import com.atlassian.bitbucket.test.ThrowableUtils;
import com.atlassian.bitbucket.test.UserTestHelper;
import com.atlassian.bitbucket.test.WebHookTestHelper;
import com.atlassian.bitbucket.test.rest.RestProjects;
import com.atlassian.bitbucket.test.rest.mirror.MirroringInstallationHelper;
import com.atlassian.bitbucket.test.rest.mirror.MirroringRequestHelper;
import com.atlassian.bitbucket.test.rest.server.stub.mirror.StubMirror;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.response.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.mutable.MutableInt;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.junit.runners.model.MultipleFailureException;
import org.springframework.core.io.Resource;

public class TestContext
extends ExternalResource
implements AutoCloseable {
    public static final String DEFAULT_EMAIL_HOST = "@testdata.atlassian.com";
    private static final List<String> FEATURE_DISCOVERY_KEYS = Arrays.asList("sidebar", "side-by-side-diff-discovery");
    private final Set<CreatedAccessKey> accessKeys = new HashSet<CreatedAccessKey>();
    private final Set<Integer> accountKeys = new HashSet<Integer>();
    private final Set<CreatedBranch> createdBranches = new HashSet<CreatedBranch>();
    private final Set<CreatedRepository> createdForks = new HashSet<CreatedRepository>();
    private final Set<String> createdGroups = new HashSet<String>();
    private final Set<String> createdProjects = new HashSet<String>();
    private final Set<PullRequestTestHelper> createdPullRequests = new HashSet<PullRequestTestHelper>();
    private final Set<CreatedRepository> createdRepositories = new HashSet<CreatedRepository>();
    private final Set<CreatedTag> createdTags = new HashSet<CreatedTag>();
    private final Set<TaskTestHelper> createdTasks = new HashSet<TaskTestHelper>();
    private final Set<String> createdUsers = new HashSet<String>();
    private final Set<String> webHookUrls = new HashSet<String>();
    private final Set<Integer> mirroringRequests = new HashSet<Integer>();
    private final Set<StubMirror> installedMirrors = new HashSet<StubMirror>();
    private final List<Throwable> errors = new ArrayList<Throwable>();
    private final Set<GrantedPermission> grantedPermissions = new HashSet<GrantedPermission>();
    private Option<MailHostConfiguration> origMailHostConfiguration;
    private Option<String> origSenderAddress;

    protected void after() {
        try {
            this.cleanup();
        }
        catch (Throwable throwable) {
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public TestContext accessKey(String projKey, Permission permission, String publicKey) {
        return this.accessKey(projKey, null, permission, publicKey);
    }

    public TestContext accessKey(String projKey, String repoSlug, Permission permission, String publicKey) {
        return this.ensureCleanup(() -> {
            Response response = repoSlug != null ? SshAccessKeysTestHelper.add(projKey, repoSlug, permission, publicKey) : SshAccessKeysTestHelper.add(projKey, permission, publicKey);
            Map keyMap = response.getBody().jsonPath().getMap("key");
            if (keyMap != null) {
                Integer keyId = (Integer)keyMap.get("id");
                this.accessKeys.add(new CreatedAccessKey(keyId, projKey, repoSlug));
            }
            return this;
        });
    }

    public TestContext accountKey(String username, String keyText) {
        return this.ensureCleanup(() -> {
            Response response = SshKeyTestHelper.addSshKey(username, keyText);
            Map keyMap = response.getBody().jsonPath().getMap("");
            if (keyMap != null) {
                this.accountKeys.add((Integer)keyMap.get("id"));
            }
            return this;
        });
    }

    public TestContext addCreatedBranch(String projectKey, String repoSlug, String branchName) {
        this.createdBranches.add(new CreatedBranch(projectKey, repoSlug, branchName));
        return this;
    }

    public void addCreatedGroup(String group) {
        this.createdGroups.add(group);
    }

    public TestContext addCreatedTag(String projectKey, String repoSlug, String tagName) {
        this.createdTags.add(new CreatedTag(projectKey, repoSlug, tagName));
        return this;
    }

    public void addCreatedUser(String username) {
        this.createdUsers.add(username);
    }

    private void addWebHook(String selfUrl) {
        this.webHookUrls.add(selfUrl);
    }

    public TestContext branch(String projectKey, String repoSlug, String branchName, String branchFrom) {
        return this.ensureCleanup(() -> {
            BranchTestHelper.createBranch(projectKey, repoSlug, branchName, branchFrom);
            return this.addCreatedBranch(projectKey, repoSlug, branchName);
        });
    }

    public void cleanup() throws Throwable {
        this.cleanupAccountKeys();
        this.cleanupAccessKeys();
        this.cleanupPullRequests();
        this.cleanupTags();
        this.cleanupBranches();
        this.cleanupRepositories();
        this.cleanupProjects();
        this.cleanupPermissions();
        this.cleanupUsers();
        this.cleanupGroups();
        this.cleanupTasks();
        this.cleanupMailConfig();
        this.cleanupWebHook();
        this.cleanupInstalledMirrors();
        this.cleanupMirroringRequests();
        MultipleFailureException.assertEmpty(this.errors);
    }

    public TestContext mailConfig(MailHostConfiguration configuration, String senderAddress) {
        if (this.origMailHostConfiguration == null) {
            this.origMailHostConfiguration = Option.option((Object)MailServerConfigHelper.getMailHostConfiguration());
        }
        if (this.origSenderAddress == null) {
            this.origSenderAddress = Option.option((Object)MailServerConfigHelper.getSenderAddress());
        }
        MailServerConfigHelper.setConfig(configuration, senderAddress);
        return this;
    }

    public TestContext project(String projectKey) {
        return this.project(projectKey, (Consumer<Integer>)null);
    }

    public TestContext project(String projectKey, String projectName) {
        return this.project(projectKey, projectName, (Consumer<Integer>)null);
    }

    public TestContext project(String projectKey, String projectName, String projectDescription) {
        return this.project(projectKey, projectName, projectDescription, (Consumer<Integer>)null);
    }

    public TestContext project(String projectKey, String projectName, String projectDescription, String projectAvatar) {
        return this.project(projectKey, projectName, projectDescription, projectAvatar, null);
    }

    public TestContext project(String projectKey, Consumer<Integer> projectIdConsumer) {
        return this.project(projectKey, projectKey, projectIdConsumer);
    }

    public TestContext project(String projectKey, String projectName, Consumer<Integer> projectIdConsumer) {
        return this.project(projectKey, projectName, "Project description for " + projectName, projectIdConsumer);
    }

    public TestContext project(String projectKey, String projectName, String projectDescription, Consumer<Integer> projectIdConsumer) {
        return this.project(projectKey, projectName, projectDescription, null, projectIdConsumer);
    }

    public TestContext project(String projectKey, String projectName, String projectDescription, String projectAvatar, Consumer<Integer> projectIdConsumer) {
        return this.ensureCleanup(() -> {
            Response response = ProjectTestHelper.createProject(projectKey, projectName, projectDescription, projectAvatar);
            if (projectIdConsumer != null) {
                projectIdConsumer.accept(response.jsonPath().getInt("id"));
            }
            this.createdProjects.add(projectKey);
            return this;
        });
    }

    public TestContext projects(String projectKeyFormat, String projectNameFormat, int projectCount) {
        return this.projects(projectKeyFormat, projectNameFormat, "Project description for %s", projectCount);
    }

    public TestContext projects(String projectKeyFormat, String projectNameFormat, String projectDescriptionFormat, int projectCount) {
        return this.ensureCleanup(() -> {
            Response response = ProjectTestHelper.createProjects(projectKeyFormat, projectNameFormat, projectDescriptionFormat, projectCount);
            try {
                RestProjects projects = (RestProjects)((Object)((Object)new ObjectMapper().readValue(response.body().print(), RestProjects.class)));
                projects.getProjects().stream().map(RestProject::getKey).forEach(this.createdProjects::add);
            }
            catch (Exception exception) {
                return this;
            }
            return this;
        });
    }

    public TestContext repository(String projectKey, String repositoryKey) {
        return this.repository(projectKey, repositoryKey, (Consumer<Integer>)null);
    }

    public TestContext repository(String projectKey, String repositoryName, boolean publiclyAccessible) {
        return this.repository(projectKey, repositoryName, publiclyAccessible, null);
    }

    public TestContext repository(String projectKey, String repositoryName, Resource repoZip) throws IOException {
        return this.repository(projectKey, repositoryName, repoZip, (Function<? super ProcessTestHelper, Object>)((Function)helper -> null), null);
    }

    public TestContext repository(String projectKey, String repositoryName, Resource repoZip, boolean publiclyAccessible) throws IOException {
        return this.repository(projectKey, repositoryName, repoZip, (Function<? super ProcessTestHelper, Object>)((Function)helper -> null), publiclyAccessible, null);
    }

    public TestContext repository(String projectKey, String repositoryName, Resource repoZip, Function<? super ProcessTestHelper, Object> callback) throws IOException {
        return this.repository(projectKey, repositoryName, repoZip, callback, false, null);
    }

    private TestContext repository(String projectKey, String repositoryName, Resource repoZip, Function<? super ProcessTestHelper, Object> callback, boolean publiclyAccessible) throws IOException {
        return this.repository(projectKey, repositoryName, repoZip, callback, publiclyAccessible, null);
    }

    public TestContext repository(String projectKey, String repositoryKey, Consumer<Integer> repositoryIdConsumer) {
        return this.repository(projectKey, repositoryKey, false, repositoryIdConsumer);
    }

    public TestContext repository(String projectKey, String repositoryName, boolean publiclyAccessible, Consumer<Integer> repositoryIdConsumer) {
        return this.ensureCleanup(() -> {
            CreatedRepository createdRepository = this.doCreateRepository(projectKey, repositoryName, publiclyAccessible);
            if (repositoryIdConsumer != null) {
                repositoryIdConsumer.accept(createdRepository.id);
            }
            return this;
        });
    }

    public TestContext repository(String projectKey, String repositoryName, Resource repoZip, Consumer<Integer> repositoryIdConsumer) throws IOException {
        return this.repository(projectKey, repositoryName, repoZip, (Function<? super ProcessTestHelper, Object>)((Function)helper -> null), repositoryIdConsumer);
    }

    public TestContext repository(String projectKey, String repositoryName, Resource repoZip, boolean publiclyAccessible, Consumer<Integer> repositoryIdConsumer) throws IOException {
        return this.repository(projectKey, repositoryName, repoZip, (Function<? super ProcessTestHelper, Object>)((Function)helper -> null), publiclyAccessible);
    }

    public TestContext repository(String projectKey, String repositoryName, Resource repoZip, Function<? super ProcessTestHelper, Object> callback, Consumer<Integer> repositoryIdConsumer) throws IOException {
        return this.repository(projectKey, repositoryName, repoZip, callback, false, repositoryIdConsumer);
    }

    private TestContext repository(String projectKey, String repositoryName, Resource repoZip, Function<? super ProcessTestHelper, Object> callback, boolean publiclyAccessible, Consumer<Integer> repositoryIdConsumer) throws IOException {
        CreatedRepository created = this.doCreateRepository(projectKey, repositoryName, publiclyAccessible);
        if (repositoryIdConsumer != null) {
            repositoryIdConsumer.accept(created.id);
        }
        TemporaryFolder temporaryFolder = new TemporaryFolder();
        temporaryFolder.create();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            TestContext testContext = this.ensureCleanup(() -> {
                try {
                    RepositoryTestHelper.pushRep(temporaryFolder, DefaultFuncTestData.getBaseURL(), DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), projectKey, createdRepository.slug, repoZip, callback);
                    return this;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            return testContext;
        }
        finally {
            temporaryFolder.delete();
        }
    }

    public TestContext fork(String projectKey, String repoKey, String username, String password) {
        return this.ensureCleanup(() -> {
            Response response = RepositoryTestHelper.forkRepositoryAndWait(projectKey, repoKey, username, password, 2500L);
            this.createdForks.add(new CreatedRepository((Integer)RepositoryTestHelper.getIdFromResponse(response), "~" + username, repoKey, (String)RepositoryTestHelper.getNameFromResponse(response)));
            return this;
        });
    }

    public TestContext forkNonPersonal(String projectKey, String repoKey, String destProjectKey, String destRepoKey) {
        return this.ensureCleanup(() -> {
            Response response = RepositoryTestHelper.forkNonPersonalRepositoryAndWait(projectKey, repoKey, destProjectKey, destRepoKey, 2500L);
            this.createdForks.add(new CreatedRepository((Integer)RepositoryTestHelper.getIdFromResponse(response), destProjectKey, destRepoKey, (String)RepositoryTestHelper.getNameFromResponse(response)));
            return this;
        });
    }

    public TestContext group(String group, String ... users) {
        return this.ensureCleanup(() -> {
            GroupTestHelper.createGroups(group);
            String[] stringArray2 = users;
            int n = users.length;
            int n2 = 0;
            while (n2 < n) {
                String user = stringArray2[n2];
                GroupTestHelper.addUserToGroup(group, user);
                ++n2;
            }
            this.addCreatedGroup(group);
            return this;
        });
    }

    public TestContext tag(String projectKey, String repoSlug, String tagName, String commitId) {
        return this.ensureCleanup(() -> {
            TagTestHelper.createTag(projectKey, repoSlug, tagName, commitId);
            return this.addCreatedTag(projectKey, repoSlug, tagName);
        });
    }

    public TestContext tag(String projectKey, String repoSlug, String tagName, String commitId, String message) {
        return this.ensureCleanup(() -> {
            TagTestHelper.createTag(projectKey, repoSlug, tagName, commitId, message);
            return this.addCreatedTag(projectKey, repoSlug, tagName);
        });
    }

    public TestContext user(String username) {
        return this.user(username, username, username, String.valueOf(username) + DEFAULT_EMAIL_HOST);
    }

    public TestContext user(String username, boolean addToDefaultGroup) {
        return this.user(username, username, username, String.valueOf(username) + DEFAULT_EMAIL_HOST, addToDefaultGroup);
    }

    public TestContext user(String username, String password) {
        return this.user(username, username, password, String.valueOf(username) + DEFAULT_EMAIL_HOST);
    }

    public TestContext user(String username, String displayName, String password) {
        return this.user(username, displayName, password, String.valueOf(username) + DEFAULT_EMAIL_HOST);
    }

    public TestContext user(String username, String displayName, String password, String emailAddress) {
        return this.user(username, displayName, password, emailAddress, true);
    }

    public TestContext user(String username, String displayName, String password, String emailAddress, boolean addToDefaultGroup) {
        return this.ensureCleanup(() -> {
            UserTestHelper.createUser(username, displayName, password, emailAddress, addToDefaultGroup);
            this.addCreatedUser(username);
            return this;
        });
    }

    public TestContext webHook(String name, String callbackUrl, List<String> eventsIds, Map<String, String> filters, String username, String password) {
        return this.ensureCleanup(() -> {
            Response response = new WebHookTestHelper(username, password).create(name, callbackUrl, eventsIds, filters, Response.Status.CREATED);
            this.addWebHook((String)response.jsonPath().get("self"));
            return this;
        });
    }

    public TestContext globalPermission(String username, Permission permission) {
        Preconditions.checkArgument((boolean)permission.isGlobal());
        return this.ensureCleanup(() -> {
            PermissionsTestHelper.setGlobalPermissionForUser(username, permission.name());
            this.grantedPermissions.add(new GrantedPermission(GrantedPermission.EntityType.USER, username, permission, null, null));
            return this;
        });
    }

    public TestContext globalPermissionForGroup(String group, Permission permission) {
        Preconditions.checkArgument((boolean)permission.isGlobal());
        return this.ensureCleanup(() -> {
            PermissionsTestHelper.setGlobalPermissionForGroup(group, permission.name());
            this.grantedPermissions.add(new GrantedPermission(GrantedPermission.EntityType.GROUP, group, permission, null, null));
            return this;
        });
    }

    public TestContext projectPermission(String projectKey, String username, Permission permission) {
        Preconditions.checkArgument((boolean)permission.isResource(Project.class));
        return this.ensureCleanup(() -> {
            PermissionsTestHelper.setProjectPermissionForUser(projectKey, username, permission.name());
            this.grantedPermissions.add(new GrantedPermission(GrantedPermission.EntityType.USER, username, permission, projectKey, null));
            return this;
        });
    }

    public TestContext repositoryPermission(String projectKey, String repoSlug, String username, Permission permission) {
        Preconditions.checkArgument((boolean)permission.isResource(Repository.class));
        return this.ensureCleanup(() -> {
            PermissionsTestHelper.setRepositoryPermissionForUser(projectKey, repoSlug, username, permission.name());
            this.grantedPermissions.add(new GrantedPermission(GrantedPermission.EntityType.USER, username, permission, projectKey, repoSlug));
            return this;
        });
    }

    public TestContext repositoryPermissionForGroup(String projectKey, String repoSlug, String group, Permission permission) {
        Preconditions.checkArgument((boolean)permission.isResource(Repository.class));
        return this.ensureCleanup(() -> {
            PermissionsTestHelper.setRepositoryPermissionForGroup(projectKey, repoSlug, group, permission.name());
            this.grantedPermissions.add(new GrantedPermission(GrantedPermission.EntityType.GROUP, group, permission, projectKey, repoSlug));
            return this;
        });
    }

    public TestContext noFeatureDiscovery(String username, String password) {
        for (String featureKey : FEATURE_DISCOVERY_KEYS) {
            RestAssured.given().auth().preemptive().basic(username, password).formParam("json", new Object[]{"{\"isAllDismissed\": true}"}).header(DefaultFuncTestData.HDR_XSRF_NO_CHECK).expect().statusCode(Response.Status.OK.getStatusCode()).when().put(String.valueOf(DefaultFuncTestData.getRestURL("chaperone", "1")) + "/chaperone/" + featureKey, new Object[0]);
        }
        return this;
    }

    public PullRequestTestHelper pullRequest(PullRequestTestHelper.Builder pullRequestBuilder) {
        return this.ensureCleanup(() -> {
            PullRequestTestHelper pullRequest = pullRequestBuilder.create();
            this.createdPullRequests.add(pullRequest);
            return pullRequest;
        });
    }

    public TestContext install(StubMirror mirror) {
        MutableInt requestId = new MutableInt();
        this.mirroringRequest(mirror.getId(), mirror.getBaseUrl(), mirror.getDescriptorUrl(), response -> requestId.setValue((Number)RepositoryTestHelper.getIdFromResponse(response)));
        MirroringRequestHelper.acceptRequest(requestId.getValue());
        this.installedMirrors.add(mirror);
        return this;
    }

    public TestContext mirroringRequest(String id, String baseUrl, String descriptorUrl) {
        return this.mirroringRequest(id, baseUrl, descriptorUrl, response -> {});
    }

    public TestContext mirroringRequest(String id, String baseUrl, String descriptorUrl, Consumer<Response> responseConsumer) {
        Response response = MirroringRequestHelper.createMirroringRequest(id, baseUrl, descriptorUrl, Response.Status.OK);
        this.mirroringRequests.add(MirroringRequestHelper.getIdFromResponse(response));
        responseConsumer.accept(response);
        return this;
    }

    public TaskTestHelper task(TaskTestHelper.Builder taskBuilder) {
        return this.ensureCleanup(() -> {
            TaskTestHelper task = taskBuilder.create();
            this.createdTasks.add(task);
            return task;
        });
    }

    private <T> T ensureCleanup(Callable<T> work) {
        try {
            return work.call();
        }
        catch (Throwable t) {
            try {
                this.cleanup();
            }
            catch (Throwable t2) {
                ThrowableUtils.throwUnchecked((Throwable)new MultipleFailureException(Arrays.asList(t, new Exception("An exception occurred while attempting to clean up", t2))));
            }
            ThrowableUtils.throwUnchecked(t);
            return null;
        }
    }

    private void cleanupAccountKeys() {
        for (Integer keyId : this.accountKeys) {
            try {
                SshKeyTestHelper.removeSshKey(keyId);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to clean up account key " + keyId, t));
            }
        }
        this.accountKeys.clear();
    }

    private void cleanupAccessKeys() {
        for (CreatedAccessKey accessKey : this.accessKeys) {
            try {
                accessKey.revoke();
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to clean up access key " + accessKey, t));
            }
        }
        this.accessKeys.clear();
    }

    private void cleanupBranches() {
        for (CreatedBranch branch : this.createdBranches) {
            try {
                BranchTestHelper.deleteBranch(branch.projectKey, branch.repoSlug, branch.branchName);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to clean up branch " + branch, t));
            }
        }
        this.createdBranches.clear();
    }

    private void cleanupMailConfig() {
        if (this.origMailHostConfiguration != null) {
            try {
                if (this.origMailHostConfiguration.isDefined()) {
                    MailServerConfigHelper.setConfig((MailHostConfiguration)this.origMailHostConfiguration.get());
                    this.origMailHostConfiguration = null;
                } else {
                    MailServerConfigHelper.deleteConfig();
                }
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to clear mail host configuration", t));
            }
        }
        if (this.origSenderAddress != null) {
            try {
                if (this.origSenderAddress.isDefined()) {
                    MailServerConfigHelper.setSenderAddress((String)this.origSenderAddress.get());
                    this.origSenderAddress = null;
                } else {
                    MailServerConfigHelper.clearSenderAddress();
                }
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to clear server email address", t));
            }
        }
    }

    private void cleanupPermissions() {
        for (GrantedPermission permission : this.grantedPermissions) {
            try {
                permission.revoke();
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to revoke permission " + permission, t));
            }
        }
        this.grantedPermissions.clear();
    }

    private void cleanupTags() {
        for (CreatedTag tag : this.createdTags) {
            try {
                TagTestHelper.deleteTag(tag.projectKey, tag.repoSlug, tag.tagName);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to clean up tag " + tag, t));
            }
        }
        this.createdTags.clear();
    }

    private void cleanupUsers() {
        for (String username : this.createdUsers) {
            try {
                UserTestHelper.deleteUsers(true, username);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to delete user " + username, t));
            }
        }
        this.createdUsers.clear();
    }

    private void cleanupGroups() {
        for (String group : this.createdGroups) {
            try {
                GroupTestHelper.deleteGroups(true, group);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to delete group " + group, t));
            }
        }
        this.createdGroups.clear();
    }

    private void cleanupRepositories() {
        this.createdForks.forEach(this::cleanupRepo);
        this.createdForks.clear();
        this.createdRepositories.forEach(this::cleanupRepo);
        this.createdRepositories.clear();
    }

    private void cleanupRepo(CreatedRepository createdRepository) {
        try {
            RepositoryTestHelper.deleteRepositoryAndWait(createdRepository.projectKey, createdRepository.slug, 1000L);
        }
        catch (Throwable t) {
            this.errors.add(new TestContextCleanupException("Failed to delete repository " + createdRepository, t));
        }
    }

    private void cleanupProjects() {
        for (String projectKey : this.createdProjects) {
            try {
                Response response = ProjectTestHelper.deleteProject(projectKey);
                Assert.assertTrue((String)("Project " + projectKey + " was not deleted"), (response.getStatusCode() == Response.Status.NO_CONTENT.getStatusCode() || response.getStatusCode() == Response.Status.NOT_FOUND.getStatusCode() ? 1 : 0) != 0);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to delete project " + projectKey, t));
            }
        }
        this.createdProjects.clear();
    }

    private void cleanupPullRequests() {
        for (PullRequestTestHelper pullRequest : this.createdPullRequests) {
            try {
                pullRequest.declineSafe();
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to cleanup pull request " + pullRequest, t));
            }
        }
        this.createdPullRequests.clear();
    }

    private void cleanupTasks() {
        for (TaskTestHelper task : this.createdTasks) {
            try {
                task.deleteSafe();
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to delete task " + task, t));
            }
        }
        this.createdTasks.clear();
    }

    private void cleanupWebHook() {
        WebHookTestHelper helper = new WebHookTestHelper(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
        for (String webHookSelfUrl : this.webHookUrls) {
            try {
                helper.delete(webHookSelfUrl);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to remove web hook " + webHookSelfUrl, t));
            }
        }
    }

    private void cleanupInstalledMirrors() {
        for (StubMirror installedMirror : this.installedMirrors) {
            try {
                MirroringInstallationHelper.uninstall(installedMirror, Response.Status.NO_CONTENT);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to uninstall mirror " + installedMirror.getBaseUrl(), t));
            }
        }
    }

    private void cleanupMirroringRequests() {
        for (Integer id : this.mirroringRequests) {
            try {
                MirroringRequestHelper.deleteRequest(id);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to delete mirroring request " + id, t));
            }
        }
    }

    private CreatedRepository doCreateRepository(String projectKey, String repositoryName, boolean publiclyAccessible) {
        JSONObject repositoryBody = RepositoryTestHelper.createRepositoryBody(repositoryName);
        repositoryBody.put((Object)"public", (Object)publiclyAccessible);
        Response response = RepositoryTestHelper.createRepositoryAndWait(projectKey, 2500L, repositoryBody);
        String slug = RepositoryTestHelper.getSlugFromResponse(response);
        int id = (Integer)RepositoryTestHelper.getIdFromResponse(response);
        CreatedRepository result = new CreatedRepository(id, projectKey, slug, repositoryName);
        this.createdRepositories.add(result);
        return result;
    }

    @Override
    public void close() throws Exception {
        try {
            this.cleanup();
        }
        catch (Throwable throwable) {
            Throwables.propagate((Throwable)throwable);
        }
    }

    public static <A> A perform(Function<TestContext, A> f) throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestContext context = new TestContext();){
            return (A)f.apply((Object)context);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static class CreatedAccessKey {
        public final Integer keyId;
        public final String projectKey;
        public final String repoSlug;

        public CreatedAccessKey(Integer keyId, String projectKey, String repoSlug) {
            this.keyId = keyId;
            this.projectKey = projectKey;
            this.repoSlug = repoSlug;
        }

        public void revoke() {
            if (this.repoSlug == null) {
                SshAccessKeysTestHelper.revoke(this.projectKey, this.keyId);
            } else {
                SshAccessKeysTestHelper.revoke(this.projectKey, this.repoSlug, this.keyId);
            }
        }

        public String toString() {
            return "{projectKey: " + this.projectKey + ", repoSlug:" + this.repoSlug + ", keyId: " + this.keyId + "}";
        }
    }

    private static class CreatedBranch {
        public final String projectKey;
        public final String repoSlug;
        public final String branchName;

        private CreatedBranch(String projectKey, String repoSlug, String branchName) {
            this.projectKey = projectKey;
            this.repoSlug = repoSlug;
            this.branchName = branchName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof CreatedBranch) {
                CreatedBranch b = (CreatedBranch)o;
                return Objects.equals(this.projectKey, b.projectKey) && Objects.equals(this.repoSlug, b.repoSlug) && Objects.equals(this.branchName, b.branchName);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.projectKey, this.repoSlug, this.branchName);
        }

        public String toString() {
            return "{projectKey: " + this.projectKey + ", repoSlug:" + this.repoSlug + ", branchName: " + this.branchName + "}";
        }
    }

    private static class CreatedRepository {
        public final int id;
        public final String projectKey;
        public final String name;
        public final String slug;

        public CreatedRepository(int id, String projectKey, String slug, String name) {
            this.id = id;
            this.projectKey = projectKey;
            this.slug = slug;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof CreatedRepository) {
                CreatedRepository r = (CreatedRepository)o;
                return Objects.equals(this.projectKey, r.projectKey) && Objects.equals(this.slug, r.slug);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.projectKey, this.slug);
        }

        public String toString() {
            return "{projectKey: " + this.projectKey + ", repoSlug:" + this.slug + "}";
        }
    }

    private static class CreatedTag {
        public final String projectKey;
        public final String repoSlug;
        public final String tagName;

        private CreatedTag(String projectKey, String repoSlug, String tagName) {
            this.projectKey = projectKey;
            this.repoSlug = repoSlug;
            this.tagName = tagName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof CreatedTag) {
                CreatedTag t = (CreatedTag)o;
                return Objects.equals(this.projectKey, t.projectKey) && Objects.equals(this.repoSlug, t.repoSlug) && Objects.equals(this.tagName, t.tagName);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.projectKey, this.repoSlug, this.tagName);
        }

        public String toString() {
            return "{projectKey: " + this.projectKey + ", repoSlug:" + this.repoSlug + ", tagName: " + this.tagName + "}";
        }
    }

    private static class GrantedPermission {
        public final Permission permission;
        public final String projectKey;
        public final String repoSlug;
        public final String entity;
        public final EntityType entityType;

        public GrantedPermission(EntityType entityType, String entity, Permission permission, String projectKey, String repoSlug) {
            this.entityType = entityType;
            this.entity = entity;
            this.permission = permission;
            this.projectKey = projectKey;
            this.repoSlug = repoSlug;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void revoke() {
            if (this.entityType == EntityType.USER) {
                if (this.permission.isGlobal()) {
                    PermissionsTestHelper.revokeGlobalPermissionsForUser(this.entity);
                    return;
                } else if (this.permission.isResource(Project.class)) {
                    PermissionsTestHelper.revokeProjectPermissionForUser(this.projectKey, this.entity);
                    return;
                } else {
                    if (!this.permission.isResource(Repository.class)) throw new IllegalStateException("Unknown permission: " + this.permission.name());
                    PermissionsTestHelper.revokeRepositoryPermissionForUser(this.projectKey, this.repoSlug, this.entity);
                }
                return;
            } else if (this.permission.isGlobal()) {
                PermissionsTestHelper.revokeGlobalPermissionsForGroup(this.entity);
                return;
            } else if (this.permission.isResource(Project.class)) {
                PermissionsTestHelper.revokeProjectPermissionForGroup(this.projectKey, this.entity);
                return;
            } else {
                if (!this.permission.isResource(Repository.class)) throw new IllegalStateException("Unknown permission: " + this.permission.name());
                PermissionsTestHelper.revokeRepositoryPermissionForGroup(this.projectKey, this.repoSlug, this.entity);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof GrantedPermission) {
                GrantedPermission gp = (GrantedPermission)o;
                return Objects.equals((Object)this.entityType, (Object)gp.entityType) && Objects.equals(this.entity, gp.entity) && Objects.equals(this.projectKey, gp.projectKey) && Objects.equals(this.repoSlug, gp.repoSlug) && Objects.equals(this.permission, gp.permission);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.entityType, this.entity, this.projectKey, this.repoSlug, this.permission});
        }

        public String toString() {
            return "{projectKey: " + this.projectKey + ", repoSlug:" + this.repoSlug + ", permission: " + this.permission + ", entityType: " + (Object)((Object)this.entityType) + ", entity: " + this.entity + "}";
        }

        public static enum EntityType {
            USER,
            GROUP;

        }
    }

    private static class TestContextCleanupException
    extends Exception {
        public TestContextCleanupException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

