/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.http.lock;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.lock.BaseLfsLockScmRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLock;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockListRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockService;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.lock.RestLfsLockPage;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LfsLockListScmRequest
extends BaseLfsLockScmRequest {
    public LfsLockListScmRequest(@Nonnull AuthenticationContext authenticationContext, @Nonnull I18nService i18nService, @Nonnull LfsLockService lfsLockService, @Nonnull Repository repository, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) {
        super(authenticationContext, i18nService, lfsLockService, repository, request, response);
    }

    @Override
    protected void doHandleRequest() throws IOException {
        int start = this.getOrDefault("cursor", 0);
        int limit = this.getOrDefault("limit", 100);
        LfsLockListRequest.Builder requestBuilder = new LfsLockListRequest.Builder(this.repository);
        Optional.ofNullable(this.request.getParameter("path")).ifPresent(requestBuilder::path);
        Optional.ofNullable(this.request.getParameter("id")).flatMap(this::tryParseAsInt).ifPresent(requestBuilder::id);
        Page<LfsLock> locks = this.lfsLockService.listLocks(requestBuilder.build(), PageUtils.newRequest((int)start, (int)limit));
        this.response.setStatus(200);
        try (ServletOutputStream outputStream = this.response.getOutputStream();){
            LfsLockListScmRequest.serialize((OutputStream)outputStream, (Object)new RestLfsLockPage(locks.getValues(), Optional.ofNullable(locks.getNextPageRequest()).map(PageRequest::getStart).orElse(null)));
        }
    }
}

