/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.http.lock;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.lock.BaseLfsLockScmRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLock;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockCreationRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockService;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.lock.RestLfsLock;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.lock.RestLfsLockCreationRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Validator;
import org.apache.commons.lang3.SystemUtils;

public class LfsLockCreateScmRequest
extends BaseLfsLockScmRequest {
    private final Validator validator;

    public LfsLockCreateScmRequest(@Nonnull AuthenticationContext authenticationContext, @Nonnull I18nService i18nService, @Nonnull LfsLockService lfsLockService, @Nonnull Repository repository, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Validator validator) {
        super(authenticationContext, i18nService, lfsLockService, repository, request, response);
        this.validator = Objects.requireNonNull(validator, "validator");
    }

    @Override
    protected void doHandleRequest() throws IOException {
        RestLfsLockCreationRequest creationRequest = LfsLockCreateScmRequest.deserialize((InputStream)this.request.getInputStream(), RestLfsLockCreationRequest.class);
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)creationRequest), (Class[])new Class[]{SystemUtils.IS_OS_WINDOWS ? RestLfsLockCreationRequest.WindowsOS.class : RestLfsLockCreationRequest.NonWindowsOS.class});
        LfsLock lock = this.lfsLockService.createLock(new LfsLockCreationRequest.Builder(creationRequest.getPath(), this.repository).build());
        this.response.setStatus(201);
        try (ServletOutputStream outputStream = this.response.getOutputStream();){
            LfsLockCreateScmRequest.serialize((OutputStream)outputStream, ImmutableMap.of((Object)"lock", (Object)((Object)new RestLfsLock(lock))));
        }
    }
}

