/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.store;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.GitLfsUtils;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.EmbeddedStoreService;
import com.atlassian.bitbucket.internal.scm.git.lfs.jwt.GitLfsJwtHelper;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BaseObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BatchRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BatchResponse;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.RequestObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.RequestOperationType;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseAction;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseActionType;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseActionsObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseErrorObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.bitbucket.internal.scm.git.lfs.store.StoreAccessor;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.jwt.CanonicalHttpRequest;
import com.atlassian.jwt.httpclient.CanonicalHttpUriRequest;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStoreAccessor
implements StoreAccessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultStoreAccessor.class);
    private final EmbeddedStoreService embeddedStoreService;
    private final I18nService i18nService;
    private final GitLfsJwtHelper jwtHelper;
    private final NavBuilder navBuilder;
    private final GitLfsSettingsService settingsService;

    public DefaultStoreAccessor(EmbeddedStoreService embeddedStoreService, I18nService i18nService, GitLfsJwtHelper jwtHelper, NavBuilder navBuilder, GitLfsSettingsService settingsService) {
        this.embeddedStoreService = embeddedStoreService;
        this.i18nService = i18nService;
        this.jwtHelper = jwtHelper;
        this.navBuilder = navBuilder;
        this.settingsService = settingsService;
    }

    @Override
    @Nonnull
    public Optional<URI> createDownloadUrl(@Nonnull Repository repository, @Nonnull String oid, @Nullable String contentType, @Nullable String contentDisposition) {
        if (!this.embeddedStoreService.objectExists(repository, oid)) {
            return Optional.empty();
        }
        try {
            UriBuilder builder = UriBuilder.fromUri((URI)new URI(this.navBuilder.buildAbsolute())).path(this.getStoreUrl(repository, oid));
            if (contentType != null) {
                builder.queryParam("response-content-type", new Object[]{contentType});
            }
            if (contentDisposition != null) {
                builder.queryParam("response-content-disposition", new Object[]{contentDisposition});
            }
            return Optional.of(builder.build(new Object[0]));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid base URL", e);
        }
    }

    @Override
    public void delete(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        this.embeddedStoreService.delete(repository);
    }

    @Override
    @Nonnull
    public BatchResponse handleBatchRequest(@Nonnull Repository repository, @Nonnull BatchRequest request) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(request, "request");
        RequestOperationType type = request.getType();
        boolean sufficientCapacity = this.isCapacitySufficient(repository, request);
        List<ResponseObject> objects = request.getObjects().stream().map(requestObject -> this.handleRequest(repository, type, (RequestObject)requestObject, sufficientCapacity)).collect(Collectors.toList());
        return new BatchResponse(objects);
    }

    private String getStoreUrl(Repository repository, String oid) {
        return String.format("/rest/git-lfs/storage/%s/%s/%s", repository.getProject().getKey(), repository.getSlug(), oid);
    }

    private ResponseObject handleRequest(Repository repository, RequestOperationType op, RequestObject request, boolean sufficientCapacity) {
        if (!op.equals((Object)RequestOperationType.DOWNLOAD) && !op.equals((Object)RequestOperationType.UPLOAD)) {
            return new ResponseErrorObject(request.getOid(), request.getSize(), 400, this.i18nService.getMessage("bitbucket.scm.git.lfs.embeddedstore.operation.unhandled", new Object[0]));
        }
        if (request.getSize() < 0L) {
            return new ResponseErrorObject(request.getOid(), request.getSize(), 422, this.i18nService.getMessage("bitbucket.scm.git.lfs.embeddedstore.object.size.invalid", new Object[0]));
        }
        if (!GitLfsUtils.isValidSha256(request.getOid())) {
            return new ResponseErrorObject(request.getOid(), request.getSize(), 422, this.i18nService.getMessage("bitbucket.scm.git.lfs.embeddedstore.object.id.invalid", new Object[0]));
        }
        if (op.equals((Object)RequestOperationType.UPLOAD) && !sufficientCapacity) {
            return new ResponseErrorObject(request.getOid(), request.getSize(), 503, this.i18nService.getMessage("bitbucket.scm.git.lfs.embeddedstore.free.space.insufficient", new Object[0]));
        }
        if (op.equals((Object)RequestOperationType.DOWNLOAD) && !this.embeddedStoreService.objectExists(repository, request.getOid())) {
            return new ResponseErrorObject(request.getOid(), request.getSize(), 404, this.i18nService.getMessage("bitbucket.scm.git.lfs.embeddedstore.object.notexist", new Object[0]));
        }
        if (op.equals((Object)RequestOperationType.UPLOAD) && this.embeddedStoreService.objectExists(repository, request.getOid())) {
            return new ResponseActionsObject(request.getOid(), request.getSize(), Collections.emptyList());
        }
        String storeUrl = this.getStoreUrl(repository, request.getOid());
        String token = this.jwtHelper.buildStorageToken((CanonicalHttpRequest)new CanonicalHttpUriRequest(op == RequestOperationType.DOWNLOAD ? "GET" : "PUT", storeUrl, null), repository, this.settingsService.getStorageTokenExpiry());
        ResponseAction action = new ResponseAction(this.toResponseActionType(op), this.navBuilder.buildAbsolute() + storeUrl, (Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)token));
        return new ResponseActionsObject(request.getOid(), request.getSize(), Collections.singletonList(action));
    }

    private boolean isCapacitySufficient(Repository repository, BatchRequest request) {
        if (request.getType() != RequestOperationType.UPLOAD) {
            return true;
        }
        long total = request.getObjects().stream().mapToLong(BaseObject::getSize).sum();
        boolean sufficientCapacity = this.embeddedStoreService.canStore(repository, total);
        if (!sufficientCapacity) {
            log.warn("Upload rejected due to insufficient available space to store {} bytes", (Object)total);
        }
        return sufficientCapacity;
    }

    private ResponseActionType toResponseActionType(RequestOperationType request) {
        if (request == RequestOperationType.DOWNLOAD) {
            return ResponseActionType.DOWNLOAD;
        }
        if (request == RequestOperationType.UPLOAD) {
            return ResponseActionType.UPLOAD;
        }
        throw new IllegalStateException("Unexpected operation type");
    }
}

