/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.settings;

import com.atlassian.bitbucket.internal.scm.git.lfs.settings.JwtSecretProvider;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.math.BigInteger;
import java.security.SecureRandom;
import javax.annotation.Nonnull;

public class DefaultJwtSecretProvider
implements JwtSecretProvider,
LifecycleAware {
    protected static final String SETTING_SHARED_SECRET = "com.atlassian.bitbucket.server.bitbucket-git-lfs.tokensecret";
    protected final PluginSettings pluginSettings;
    private final TransactionTemplate transactionTemplate;

    public DefaultJwtSecretProvider(PluginSettingsFactory pluginSettingsFactory, TransactionTemplate transactionTemplate) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    @Nonnull
    public String getSecret() {
        String sharedSecret = (String)this.pluginSettings.get(SETTING_SHARED_SECRET);
        if (sharedSecret == null) {
            sharedSecret = (String)this.transactionTemplate.execute(() -> {
                String secret = (String)this.pluginSettings.get(SETTING_SHARED_SECRET);
                if (secret == null) {
                    secret = this.generateSharedSecret();
                    this.pluginSettings.put(SETTING_SHARED_SECRET, (Object)secret);
                }
                return secret;
            });
        }
        return sharedSecret;
    }

    public void onStart() {
    }

    public void onStop() {
    }

    protected String generateSharedSecret() {
        SecureRandom random = new SecureRandom();
        return new BigInteger(256, random).toString(32);
    }
}

