/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.rest.model;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.BadBatchRequestException;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BatchRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.RequestObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.RequestOperationType;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.model.RestRequestObject;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.util.MoreCollectors;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class RestBatchRequest
extends RestMapEntity {
    private static final String OBJECTS_KEY = "objects";
    private static final String OPERATION_KEY = "operation";

    public RestBatchRequest() {
    }

    public RestBatchRequest(@Nonnull BatchRequest request) {
        this.put(OPERATION_KEY, request.getType().toString().toLowerCase(Locale.ROOT));
        this.put(OBJECTS_KEY, RestBatchRequest.transform(request.getObjects(), RestRequestObject::new));
    }

    @Nonnull
    public BatchRequest fromRest(@Nonnull I18nService i18nService) {
        RequestOperationType operationType;
        String operation = this.getOperation();
        if (operation == null) {
            throw new BadBatchRequestException(i18nService.getMessage("bitbucket.scm.git.lfs.request.missing.attribute", new Object[]{OPERATION_KEY}));
        }
        try {
            operationType = RequestOperationType.valueOf(operation.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadBatchRequestException(i18nService.getMessage("bitbucket.scm.git.lfs.request.unsupported.operation", new Object[]{operation}));
        }
        return new BatchRequest(operationType, this.getObjects(i18nService));
    }

    private List<RequestObject> getObjects(I18nService i18nService) {
        List objects = (List)this.get(OBJECTS_KEY);
        if (objects == null) {
            throw new BadBatchRequestException(i18nService.getMessage("bitbucket.scm.git.lfs.request.missing.attribute", new Object[]{OBJECTS_KEY}));
        }
        return (List)objects.stream().map(object -> RestRequestObject.valueOf(object).fromRest(i18nService)).collect(MoreCollectors.toImmutableList());
    }

    private String getOperation() {
        return this.getStringProperty(OPERATION_KEY);
    }
}

