/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.http;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.LfsService;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.BaseLfsHttpScmRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.LfsHttpScmUtils;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BatchRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BatchResponse;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.model.RestBatchRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.model.RestBatchResponse;
import com.atlassian.bitbucket.repository.Repository;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class LfsBatchScmRequest
extends BaseLfsHttpScmRequest {
    protected final LfsService lfsService;

    public LfsBatchScmRequest(@Nonnull AuthenticationContext authenticationContext, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull I18nService i18nService, @Nonnull LfsService lfsService, @Nonnull Repository repository) {
        super(authenticationContext, request, response, i18nService, repository);
        this.lfsService = Objects.requireNonNull(lfsService, "lfsService");
    }

    public void handleRequest() throws IOException {
        ObjectMapper mapper = this.createMapper();
        try {
            BatchRequest batchRequest = ((RestBatchRequest)((Object)mapper.readValue((InputStream)this.request.getInputStream(), RestBatchRequest.class))).fromRest(this.i18nService);
            BatchResponse batchResponse = this.lfsService.handleBatchRequest(this.repository, batchRequest);
            this.response.setContentType("application/vnd.git-lfs+json; charset=utf-8");
            this.response.setStatus(200);
            try (ServletOutputStream outputStream = this.response.getOutputStream();){
                mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
                mapper.writeValue((OutputStream)outputStream, (Object)new RestBatchResponse(batchResponse));
            }
        }
        catch (AuthorisationException e) {
            if (!this.authenticationContext.isAuthenticated()) {
                LfsHttpScmUtils.sendError(this.response, 401, this.i18nService.getMessage("bitbucket.scm.git.lfs.request.not.authenticated", new Object[0]));
            } else {
                LfsHttpScmUtils.sendError(this.response, (Exception)((Object)e));
            }
        }
        catch (RuntimeException | JsonParseException e) {
            LfsHttpScmUtils.sendError(this.response, (Exception)e);
        }
    }
}

