/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.store;

import com.atlassian.bitbucket.dmz.git.lfs.DmzEmbeddedStoreService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.jwt.GitLfsJwtHelper;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.DefaultUpstreamLfsClient;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.bitbucket.internal.scm.git.lfs.store.DefaultStoreAccessor;
import com.atlassian.bitbucket.internal.scm.git.lfs.store.MirrorStoreAccessor;
import com.atlassian.bitbucket.internal.scm.git.lfs.store.StoreAccessor;
import com.atlassian.bitbucket.json.JsonRenderer;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class EmbeddedStoreAccessorFactoryBean
extends AbstractFactoryBean<StoreAccessor>
implements DisposableBean {
    private final BundleContext context;
    private final DmzEmbeddedStoreService embeddedStoreService;
    private final I18nService i18nService;
    private final JsonRenderer jsonRenderer;
    private final GitLfsJwtHelper jwtHelper;
    private final NavBuilder navBuilder;
    private final ApplicationPropertiesService propertiesService;
    private final RequestManager requestManager;
    private final GitLfsSettingsService settingsService;

    public EmbeddedStoreAccessorFactoryBean(BundleContext context, DmzEmbeddedStoreService embeddedStoreService, I18nService i18nService, JsonRenderer jsonRenderer, GitLfsJwtHelper jwtHelper, NavBuilder navBuilder, ApplicationPropertiesService propertiesService, RequestManager requestManager, GitLfsSettingsService settingsService) {
        this.context = context;
        this.embeddedStoreService = embeddedStoreService;
        this.i18nService = i18nService;
        this.jsonRenderer = jsonRenderer;
        this.jwtHelper = jwtHelper;
        this.navBuilder = navBuilder;
        this.propertiesService = propertiesService;
        this.settingsService = settingsService;
        this.requestManager = requestManager;
    }

    public Class<?> getObjectType() {
        return StoreAccessor.class;
    }

    protected StoreAccessor createInstance() {
        return this.propertiesService.getMode() == ApplicationMode.DEFAULT ? new DefaultStoreAccessor(this.embeddedStoreService, this.i18nService, this.jwtHelper, this.navBuilder, this.settingsService) : new MirrorStoreAccessor(this.embeddedStoreService, this.i18nService, this.jwtHelper, this.navBuilder, this.settingsService, new DefaultUpstreamLfsClient(this.i18nService, this.jsonRenderer, this.context, this.requestManager));
    }

    protected void destroyInstance(StoreAccessor instance) throws Exception {
        if (instance instanceof MirrorStoreAccessor) {
            ((MirrorStoreAccessor)instance).destroy();
        }
    }
}

