/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.settings;

import com.atlassian.bitbucket.dmz.mirror.DmzSecretService;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.DefaultJwtSecretProvider;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorJwtSecretProvider
extends DefaultJwtSecretProvider {
    private static final Logger log = LoggerFactory.getLogger(MirrorJwtSecretProvider.class);
    private final DmzSecretService secretService;
    private String registrationId;
    private volatile boolean started;

    public MirrorJwtSecretProvider(DmzSecretService secretService, PluginSettingsFactory pluginSettingsFactory, TransactionTemplate transactionTemplate) {
        super(pluginSettingsFactory, transactionTemplate);
        this.secretService = secretService;
    }

    @Override
    @Nonnull
    public String getSecret() {
        if (!this.started) {
            throw new IllegalStateException("Attempted to get secret before plugin has started");
        }
        return (String)this.pluginSettings.get("com.atlassian.bitbucket.server.bitbucket-git-lfs.tokensecret");
    }

    @Override
    public void onStart() {
        this.registrationId = this.secretService.registerChangeListener("com.atlassian.bitbucket.server.bitbucket-git-lfs.tokensecret", secret -> this.pluginSettings.put("com.atlassian.bitbucket.server.bitbucket-git-lfs.tokensecret", secret));
        this.synchronizeSecretWithFarm();
        this.started = true;
    }

    @Override
    public void onStop() {
        this.secretService.unregisterChangeListener(this.registrationId);
        this.started = false;
    }

    private void synchronizeSecretWithFarm() {
        this.secretService.compute("com.atlassian.bitbucket.server.bitbucket-git-lfs.tokensecret", secret -> {
            String localSecret = (String)this.pluginSettings.get("com.atlassian.bitbucket.server.bitbucket-git-lfs.tokensecret");
            if (secret == null) {
                if (localSecret == null) {
                    log.debug("Secret doesn't exist in plugin settings. Generating secret and sharing with mirror farm...");
                    localSecret = this.generateSharedSecret();
                    this.pluginSettings.put("com.atlassian.bitbucket.server.bitbucket-git-lfs.tokensecret", (Object)localSecret);
                    return localSecret;
                }
                log.debug("Secret exists in plugin settings. Sharing with mirror farm...");
                return localSecret;
            }
            if (!secret.equals(localSecret)) {
                log.debug("Farm secret is different from secret in plugin settings. Updating plugin settings...");
                this.pluginSettings.put("com.atlassian.bitbucket.server.bitbucket-git-lfs.tokensecret", secret);
            }
            return secret;
        });
    }
}

