/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.model;

import com.atlassian.bitbucket.internal.scm.git.lfs.model.OperationType;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ResponseAction {
    private final Map<String, String> headers;
    private final String href;
    private final OperationType type;

    public ResponseAction(@Nonnull OperationType type, @Nonnull String href, @Nonnull Map<String, String> headers) {
        this.type = Objects.requireNonNull(type, "type");
        this.href = Objects.requireNonNull(href, "href");
        this.headers = new HashMap<String, String>(Objects.requireNonNull(headers, "header"));
    }

    public ResponseAction(@Nonnull OperationType type, @Nonnull String href, @Nonnull String authToken) {
        this.type = Objects.requireNonNull(type, "type");
        this.href = Objects.requireNonNull(href, "href");
        this.headers = ImmutableMap.of((Object)"Authorization", (Object)Objects.requireNonNull(authToken, "authToken"));
    }

    public ResponseAction(@Nonnull OperationType type, @Nonnull String href) {
        this(type, href, Collections.emptyMap());
    }

    @Nonnull
    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Nonnull
    public String getHref() {
        return this.href;
    }

    @Nonnull
    public OperationType getType() {
        return this.type;
    }
}

