/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.fragments;

import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.bitbucket.ui.ContextualFormFragment;
import com.atlassian.bitbucket.ui.ValidationErrors;
import com.atlassian.bitbucket.view.TemplateRenderingException;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class GitLfsAdminSettingsFormFragment
implements ContextualFormFragment {
    private static final String MODULE_KEY = "com.atlassian.bitbucket.server.bitbucket-git-lfs:lfs-admin-soy-templates";
    private static final String FRAGMENT_TEMPLATE = "bitbucketPluginGitLfs.internal.admin.lfsAdminSettings.fragment";
    private static final String SOY_FIELD_ENABLED = "lfsEnabled";
    private final GitLfsSettingsService gitLfsSettingsService;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public GitLfsAdminSettingsFormFragment(GitLfsSettingsService gitLfsSettingsService, SoyTemplateRenderer soyTemplateRenderer) {
        this.gitLfsSettingsService = gitLfsSettingsService;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    public void doView(Appendable appendable, Map<String, Object> context) throws IOException {
        context.put(SOY_FIELD_ENABLED, this.gitLfsSettingsService.isEnabled());
        this.renderView(appendable, context);
    }

    public void validate(Map<String, String[]> requestParams, ValidationErrors errors, Map<String, Object> context) {
    }

    public void doError(Appendable appendable, Map<String, String[]> requestParams, Map<String, Collection<String>> fieldErrors, Map<String, Object> context) throws IOException {
        context.put(SOY_FIELD_ENABLED, GitLfsAdminSettingsFormFragment.isCheckBoxEnabled(requestParams));
        this.renderView(appendable, context);
    }

    public void execute(Map<String, String[]> requestParams, Map<String, Object> context) {
        this.gitLfsSettingsService.setEnabled(GitLfsAdminSettingsFormFragment.isCheckBoxEnabled(requestParams));
    }

    private void renderView(Appendable appendable, Map<String, Object> context) {
        try {
            this.soyTemplateRenderer.render(appendable, MODULE_KEY, FRAGMENT_TEMPLATE, context);
        }
        catch (SoyException e) {
            throw new TemplateRenderingException("Failed to render bitbucketPluginGitLfs.internal.admin.lfsAdminSettings.fragment", (Throwable)e);
        }
    }

    private static boolean isCheckBoxEnabled(Map<String, String[]> requestParams) {
        String[] values = requestParams.get(SOY_FIELD_ENABLED);
        return values != null && values[0].equalsIgnoreCase("on");
    }
}

