/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.embedded;

import com.atlassian.bitbucket.NoSuchObjectException;
import com.atlassian.bitbucket.dmz.git.lfs.DmzEmbeddedStoreService;
import com.atlassian.bitbucket.dmz.git.lfs.ObjectByteRange;
import com.atlassian.bitbucket.dmz.git.lfs.ObjectStreamingOutput;
import com.atlassian.bitbucket.dmz.git.lfs.ReadObjectRequest;
import com.atlassian.bitbucket.dmz.repository.DmzRepository;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.io.CountingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.ws.rs.WebApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitionalEmbeddedStoreService
implements DmzEmbeddedStoreService {
    private static final Logger log = LoggerFactory.getLogger(TransitionalEmbeddedStoreService.class);
    private final DmzEmbeddedStoreService localService;
    private final DmzEmbeddedStoreService meshService;

    public TransitionalEmbeddedStoreService(DmzEmbeddedStoreService localService, DmzEmbeddedStoreService meshService) {
        this.localService = localService;
        this.meshService = meshService;
    }

    public boolean canStore(@Nonnull Repository repository, long size) {
        return this.getService(repository).canStore(repository, size);
    }

    public void delete(@Nonnull Repository repository) {
        try {
            this.localService.delete(repository);
        }
        catch (RuntimeException e) {
            if (DmzRepository.isRemote((Repository)repository)) {
                log.info("[{}] Failed to delete LFS data from the local LFS store for remote repository", (Object)repository, (Object)e);
            }
            throw e;
        }
    }

    public boolean objectExists(@Nonnull Repository repository, @Nonnull String oid) {
        if (DmzRepository.isRemote((Repository)repository) && this.meshService.objectExists(repository, oid)) {
            return true;
        }
        return this.localService.objectExists(repository, oid);
    }

    @Nonnull
    public ObjectStreamingOutput readObject(@Nonnull ReadObjectRequest request) {
        if (DmzRepository.isRemote((Repository)request.getRepository())) {
            return new ObjectStreamingOutputWithFallback(this.meshService.readObject(request), () -> this.localService.readObject(request));
        }
        return this.localService.readObject(request);
    }

    public void writeObject(@Nonnull Repository repository, @Nonnull String oid, @Nonnull InputStream is) {
        this.getService(repository).writeObject(repository, oid, is);
    }

    private DmzEmbeddedStoreService getService(Repository repository) {
        return DmzRepository.isRemote((Repository)repository) ? this.meshService : this.localService;
    }

    private static class ObjectStreamingOutputWithFallback
    implements ObjectStreamingOutput {
        private final Supplier<ObjectStreamingOutput> fallbackSupplier;
        private final ObjectStreamingOutput delegate;

        private ObjectStreamingOutputWithFallback(ObjectStreamingOutput delegate, Supplier<ObjectStreamingOutput> fallbackSupplier) {
            this.delegate = delegate;
            this.fallbackSupplier = fallbackSupplier;
        }

        @Nonnull
        public Optional<ObjectByteRange> range() {
            return this.delegate.range();
        }

        public void write(OutputStream output) throws IOException, WebApplicationException {
            CountingOutputStream countingOutput = new CountingOutputStream(output);
            try {
                this.delegate.write((OutputStream)countingOutput);
            }
            catch (NoSuchObjectException | IOException | WebApplicationException e) {
                if (countingOutput.getCount() == 0L) {
                    this.fallbackSupplier.get().write(output);
                }
                throw e;
            }
        }
    }
}

