/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.embedded;

import com.atlassian.bitbucket.dmz.server.DmzStorageService;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.MoreFiles;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nonnull;

public class LfsFileSystemHelper {
    private static final String STORE_DIRECTORY_SUFFIX = "git-lfs/storage";
    private final long minimumFreeSpace;
    private final DmzStorageService storageService;
    private final Path storeDir;

    public LfsFileSystemHelper(GitLfsSettingsService settingsService, DmzStorageService storageService) {
        this.storageService = storageService;
        this.storeDir = MoreFiles.mkdir((Path)storageService.getDataDir(), (String)STORE_DIRECTORY_SUFFIX);
        this.minimumFreeSpace = settingsService.getMinimumFreeSpace();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canOpen(@Nonnull Path objectFile) {
        Objects.requireNonNull(objectFile, "objectFile");
        try (InputStream ignored = Files.newInputStream(objectFile, new OpenOption[0]);){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String extractOid(@Nonnull Path objectFile) {
        int offset = Objects.requireNonNull(objectFile, "objectFile").getNameCount() - 2;
        if (offset < 0) {
            throw new IllegalArgumentException(objectFile + " is not a valid object path");
        }
        return objectFile.getName(offset).toString() + objectFile.getName(offset + 1);
    }

    public static Path getObjectPath(@Nonnull Path hierarchyDir, @Nonnull String oid) {
        Objects.requireNonNull(hierarchyDir, "hierarchyDir");
        LfsFileSystemHelper.requireOid(oid);
        return hierarchyDir.resolve(oid.substring(0, 2)).resolve(oid.substring(2));
    }

    public long getUsableSpace(@Nonnull Path objectFile) {
        int nameCount = Objects.requireNonNull(objectFile, "objectFile").getNameCount();
        if (objectFile.isAbsolute() && nameCount > 4) {
            Path subpath = objectFile.subpath(0, nameCount - 3);
            Path storeDir = objectFile.getRoot().resolve(subpath);
            if (storeDir.equals(this.storeDir) || "lfs".equals(objectFile.getName(nameCount - 3).toString())) {
                return this.calculateUsableSpace(storeDir);
            }
        }
        throw new IllegalArgumentException(objectFile + " is not a valid object path");
    }

    public long getUsableSpace(@Nonnull Repository repository) {
        return this.calculateUsableSpace(this.storageService.getHierarchyDir(repository).orElse(this.storeDir));
    }

    public Path getHierarchyPath(@Nonnull Repository repository) {
        return this.storageService.getHierarchyDir(repository).map(hierarchyDir -> hierarchyDir.resolve("lfs")).orElseGet(() -> this.storeDir.resolve(repository.getHierarchyId()));
    }

    public long getMinimumFreeSpace() {
        return this.minimumFreeSpace;
    }

    public Path getObjectPath(@Nonnull Repository repository, @Nonnull String oid) {
        return LfsFileSystemHelper.getObjectPath(this.getHierarchyPath(repository), oid);
    }

    public boolean objectExists(@Nonnull Repository repository, @Nonnull String oid) {
        Objects.requireNonNull(repository, "repository");
        LfsFileSystemHelper.requireOid(oid);
        return Files.exists(this.getObjectPath(repository, oid), new LinkOption[0]);
    }

    private long calculateUsableSpace(Path path) {
        try {
            long freeSpace = Files.getFileStore(path).getUsableSpace();
            return Math.max(0L, freeSpace - this.minimumFreeSpace);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to retrieve free space for filesystem: " + path, e);
        }
    }

    private static void requireOid(String value) {
        if (Objects.requireNonNull(value, "oid").trim().isEmpty()) {
            throw new IllegalArgumentException("A non-blank OID is required");
        }
    }
}

