/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.embedded;

import com.atlassian.bitbucket.dmz.git.lfs.DmzEmbeddedStoreService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.DefaultEmbeddedStoreService;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.LfsFileSystemHelper;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.TransitionalEmbeddedStoreService;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.DefaultUpstreamLfsClient;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.MirrorEmbeddedStoreService;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.bitbucket.json.JsonRenderer;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.throttle.ThrottleService;
import com.atlassian.bitbucket.user.SecurityService;
import javax.annotation.Nonnull;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class EmbeddedStoreServiceFactoryBean
extends AbstractFactoryBean<DmzEmbeddedStoreService> {
    private static final String PROP_MESH_ENABLED = "plugin.bitbucket-git-lfs.mesh.enabled";
    private static final String PROP_SIDECAR_ENABLED = "plugin.bitbucket-git.mesh.sidecar.enabled";
    private final BundleContext context;
    private final I18nService i18nService;
    private final JsonRenderer jsonRenderer;
    private final LfsFileSystemHelper lfsFileSystemHelper;
    private final ApplicationPropertiesService propertiesService;
    private final RepositoryService repositoryService;
    private final RequestManager requestManager;
    private final SecurityService securityService;
    private final GitLfsSettingsService settingsService;
    private final ThrottleService throttleService;
    private final PermissionValidationService validationService;

    public EmbeddedStoreServiceFactoryBean(BundleContext context, I18nService i18nService, JsonRenderer jsonRenderer, LfsFileSystemHelper lfsFileSystemHelper, ApplicationPropertiesService propertiesService, RepositoryService repositoryService, RequestManager requestManager, SecurityService securityService, GitLfsSettingsService settingsService, ThrottleService throttleService, PermissionValidationService validationService) {
        this.context = context;
        this.i18nService = i18nService;
        this.jsonRenderer = jsonRenderer;
        this.lfsFileSystemHelper = lfsFileSystemHelper;
        this.propertiesService = propertiesService;
        this.repositoryService = repositoryService;
        this.requestManager = requestManager;
        this.securityService = securityService;
        this.settingsService = settingsService;
        this.throttleService = throttleService;
        this.validationService = validationService;
    }

    public Class<?> getObjectType() {
        return DmzEmbeddedStoreService.class;
    }

    @Nonnull
    protected DmzEmbeddedStoreService createInstance() {
        if (this.propertiesService.getMode() == ApplicationMode.MIRROR) {
            return new MirrorEmbeddedStoreService(this.i18nService, this.lfsFileSystemHelper, this.repositoryService, this.securityService, this.settingsService, this.throttleService, new DefaultUpstreamLfsClient(this.i18nService, this.jsonRenderer, this.context, this.requestManager));
        }
        boolean hasLfsReplicationBeenImplemented = false;
        if (hasLfsReplicationBeenImplemented && this.propertiesService.getPluginProperty(PROP_MESH_ENABLED, false)) {
            ServiceTracker serviceTracker = new ServiceTracker(this.context, DmzEmbeddedStoreService.class, null);
            serviceTracker.open();
            DmzEmbeddedStoreService meshStoreService = (DmzEmbeddedStoreService)serviceTracker.getService();
            if (this.propertiesService.getPluginProperty(PROP_SIDECAR_ENABLED, true)) {
                return meshStoreService;
            }
            DefaultEmbeddedStoreService localStoreService = new DefaultEmbeddedStoreService(this.i18nService, this.lfsFileSystemHelper, this.settingsService, this.repositoryService, this.throttleService, this.securityService, this.validationService);
            return new TransitionalEmbeddedStoreService(localStoreService, meshStoreService);
        }
        return new DefaultEmbeddedStoreService(this.i18nService, this.lfsFileSystemHelper, this.settingsService, this.repositoryService, this.throttleService, this.securityService, this.validationService);
    }

    protected void destroyInstance(DmzEmbeddedStoreService instance) throws Exception {
        if (instance instanceof MirrorEmbeddedStoreService) {
            ((MirrorEmbeddedStoreService)instance).destroy();
        }
    }
}

