/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.embedded;

import com.atlassian.bitbucket.dmz.git.lfs.DmzEmbeddedStoreService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.GitLfsDisabledException;
import com.atlassian.bitbucket.internal.scm.git.lfs.GitLfsUtils;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.LfsFileSystemHelper;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEmbeddedStoreService
implements DmzEmbeddedStoreService {
    public static final String LFS_THROTTLE_BUCKET = "git-lfs";
    private static final Logger log = LoggerFactory.getLogger(AbstractEmbeddedStoreService.class);
    protected final I18nService i18nService;
    protected final LfsFileSystemHelper lfsFileSystemHelper;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;
    private final GitLfsSettingsService settingsService;

    public AbstractEmbeddedStoreService(I18nService i18nService, LfsFileSystemHelper lfsFileSystemHelper, RepositoryService repositoryService, SecurityService securityService, GitLfsSettingsService settingsService) {
        this.i18nService = i18nService;
        this.lfsFileSystemHelper = lfsFileSystemHelper;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
        this.settingsService = settingsService;
    }

    public boolean canStore(@Nonnull Repository repository, long size) {
        Objects.requireNonNull(repository, "repository");
        return this.lfsFileSystemHelper.getUsableSpace(repository) >= size;
    }

    public void delete(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        Page related = (Page)this.securityService.withPermission(Permission.REPO_READ, "Finding related repositories").call(() -> this.repositoryService.findRelated(repository, PageUtils.newRequest((int)0, (int)1)));
        if (related.getSize() == 0 && related.getIsLastPage()) {
            String hierarchyId = repository.getHierarchyId();
            try {
                log.debug("Deleting LFS content for hierarchy {}", (Object)hierarchyId);
                MoreFiles.deleteRecursively((Path)this.lfsFileSystemHelper.getHierarchyPath(repository));
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                log.debug("LFS directory for hierarchy {} does not exist. Nothing to delete.", (Object)hierarchyId);
            }
            catch (IOException e) {
                log.error("Failed to delete LFS content for hierarchy {}", (Object)hierarchyId, (Object)e);
            }
        }
    }

    public boolean objectExists(@Nonnull Repository repository, @Nonnull String oid) {
        this.validateOid(oid);
        return this.lfsFileSystemHelper.objectExists(repository, oid);
    }

    protected void requireLfsEnabled() {
        if (!this.settingsService.isEnabled()) {
            throw new GitLfsDisabledException(this.i18nService.createKeyedMessage("bitbucket.scm.git.lfs.disabled", new Object[0]));
        }
    }

    protected void validateOid(String oid) {
        if (!GitLfsUtils.isValidSha256(oid)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.scm.git.lfs.embeddedstore.object.id.invalid", new Object[0]));
        }
    }
}

