/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.store;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.GitLfsUtils;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.EmbeddedStoreService;
import com.atlassian.bitbucket.internal.scm.git.lfs.jwt.GitLfsJwtHelper;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.UpstreamLfsClient;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BaseObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BatchRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BatchResponse;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.OperationType;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.RequestObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseAction;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseActionObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseErrorObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.bitbucket.internal.scm.git.lfs.store.StoreAccessor;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.jwt.CanonicalHttpRequest;
import com.atlassian.jwt.httpclient.CanonicalHttpUriRequest;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class MirrorStoreAccessor
implements StoreAccessor,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MirrorStoreAccessor.class);
    private final EmbeddedStoreService embeddedStoreService;
    private final I18nService i18nService;
    private final GitLfsJwtHelper jwtHelper;
    private final NavBuilder navBuilder;
    private final GitLfsSettingsService settingsService;
    private final UpstreamLfsClient upstreamLfsClient;

    public MirrorStoreAccessor(EmbeddedStoreService embeddedStoreService, I18nService i18nService, GitLfsJwtHelper jwtHelper, NavBuilder navBuilder, GitLfsSettingsService settingsService, UpstreamLfsClient upstreamLfsClient) {
        this.embeddedStoreService = embeddedStoreService;
        this.i18nService = i18nService;
        this.jwtHelper = jwtHelper;
        this.navBuilder = navBuilder;
        this.settingsService = settingsService;
        this.upstreamLfsClient = upstreamLfsClient;
    }

    @Override
    public void delete(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        this.embeddedStoreService.delete(repository);
    }

    public void destroy() throws Exception {
        this.upstreamLfsClient.destroy();
    }

    @Override
    @Nonnull
    public BatchResponse handleBatchRequest(@Nonnull Repository repository, @Nonnull BatchRequest request) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(request, "request");
        boolean sufficientCapacity = this.isCapacitySufficient(repository, request);
        List<ResponseObject> objects = request.getObjects().stream().map(requestObject -> this.handleRequest(repository, request.getType(), (RequestObject)requestObject, sufficientCapacity)).collect(Collectors.toList());
        return new BatchResponse(objects);
    }

    private String getStoreUrl(Repository repository, String oid) {
        return String.format("/rest/git-lfs/storage/%s/%s/%s/%s", repository.getProject().getNamespace(), repository.getProject().getKey(), repository.getSlug(), oid);
    }

    private ResponseObject handleDownload(Repository repository, OperationType op, RequestObject request, boolean sufficientCapacity) {
        if (!sufficientCapacity) {
            return new ResponseErrorObject(request.getOid(), request.getSize(), 503, this.i18nService.getMessage("bitbucket.scm.git.lfs.embeddedstore.free.space.insufficient", new Object[0]));
        }
        String storeUrl = this.getStoreUrl(repository, request.getOid());
        String token = this.jwtHelper.buildStorageToken((CanonicalHttpRequest)new CanonicalHttpUriRequest("GET", storeUrl, null), repository, this.settingsService.getStorageTokenExpiry());
        ResponseAction action = new ResponseAction(op, this.navBuilder.buildAbsolute() + storeUrl, token);
        return new ResponseActionObject(request.getOid(), request.getSize(), Collections.singletonList(action));
    }

    private ResponseObject handleRequest(Repository repository, OperationType op, RequestObject request, boolean sufficientCapacity) {
        if (request.getSize() < 0L) {
            return new ResponseErrorObject(request.getOid(), request.getSize(), 422, this.i18nService.getMessage("bitbucket.scm.git.lfs.embeddedstore.object.size.invalid", new Object[0]));
        }
        if (!GitLfsUtils.isValidSha256(request.getOid())) {
            return new ResponseErrorObject(request.getOid(), request.getSize(), 422, this.i18nService.getMessage("bitbucket.scm.git.lfs.embeddedstore.object.id.invalid", new Object[0]));
        }
        if (op.equals((Object)OperationType.UPLOAD)) {
            return this.handleUpload(repository, request);
        }
        if (op.equals((Object)OperationType.DOWNLOAD)) {
            return this.handleDownload(repository, op, request, sufficientCapacity);
        }
        return new ResponseErrorObject(request.getOid(), request.getSize(), 400, this.i18nService.getMessage("bitbucket.scm.git.lfs.embeddedstore.operation.unhandled", new Object[0]));
    }

    private ResponseObject handleUpload(Repository repository, RequestObject request) {
        Set actions = this.upstreamLfsClient.proxyUploadRequest(repository, request).map(Collections::singleton).orElseGet(Collections::emptySet);
        return new ResponseActionObject(request.getOid(), request.getSize(), actions);
    }

    private boolean isCapacitySufficient(Repository repository, BatchRequest request) {
        long total;
        boolean sufficientSpace;
        long usableSpace = this.embeddedStoreService.getUsableSpace(repository);
        boolean bl = sufficientSpace = usableSpace - (total = request.getObjects().stream().filter(requestObject -> !this.embeddedStoreService.objectExists(repository, requestObject.getOid())).mapToLong(BaseObject::getSize).sum()) > 0L;
        if (!sufficientSpace) {
            log.warn("Request rejected due to insufficient available space in store - Required: {} Available: {}", (Object)total, (Object)usableSpace);
        }
        return sufficientSpace;
    }
}

