/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.settings;

import com.atlassian.bitbucket.internal.scm.git.lfs.dao.GitLfsRepositoryConfigDao;
import com.atlassian.bitbucket.internal.scm.git.lfs.event.GitLfsDisabledEvent;
import com.atlassian.bitbucket.internal.scm.git.lfs.event.GitLfsEnabledEvent;
import com.atlassian.bitbucket.internal.scm.git.lfs.event.GitLfsFeatureDisabledEvent;
import com.atlassian.bitbucket.internal.scm.git.lfs.event.GitLfsFeatureEnabledEvent;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class DefaultGitLfsSettingsService
implements GitLfsSettingsService {
    private static final long DEFAULT_BATCH_TOKEN_EXPIRY = TimeUnit.MINUTES.toSeconds(5L);
    private static final long DEFAULT_MINIMUM_FREE_SPACE = 0x6400000L;
    private static final long DEFAULT_MIRROR_EVICTION_ENTRIES = 100L;
    private static final long DEFAULT_MIRROR_MAX_IN_MEMORY_ENTRIES = 10000L;
    private static final long DEFAULT_STORAGE_TOKEN_EXPIRY = TimeUnit.DAYS.toSeconds(1L);
    private static final String PROP_BATCH_TOKEN_EXPIRY = "plugin.bitbucket-git-lfs.token.batch.expiry";
    private static final String PROP_MINIMUM_FREE_SPACE = "plugin.bitbucket-git-lfs.minimum.free.space";
    private static final String PROP_MIRROR_EVICTION_ENTRIES = "plugin.bitbucket-git-lfs.mirror.eviction.entries";
    private static final String PROP_MIRROR_MAX_IN_MEMORY_ENTRIES = "plugin.bitbucket-git-lfs.mirror.max.memory.entries";
    private static final String PROP_STORAGE_TOKEN_EXPIRY = "plugin.bitbucket-git-lfs.token.storage.expiry";
    private static final String SETTING_ENABLED = "com.atlassian.bitbucket.server.bitbucket-git-lfs.enabled";
    private static final String SETTING_SHARED_SECRET = "com.atlassian.bitbucket.server.bitbucket-git-lfs.tokensecret";
    private final GitLfsRepositoryConfigDao configDao;
    private final EventPublisher eventPublisher;
    private final PluginSettings pluginSettings;
    private final ApplicationPropertiesService propertiesService;
    private final TransactionTemplate transactionTemplate;

    public DefaultGitLfsSettingsService(GitLfsRepositoryConfigDao configDao, EventPublisher eventPublisher, PluginSettingsFactory pluginSettingsFactory, ApplicationPropertiesService propertiesService, TransactionTemplate transactionTemplate) {
        this.configDao = configDao;
        this.eventPublisher = eventPublisher;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.propertiesService = propertiesService;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public void cleanup(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        this.transactionTemplate.execute(() -> {
            this.configDao.cleanup(repository);
            return null;
        });
    }

    @Override
    public long getBatchTokenExpiry() {
        return this.propertiesService.getPluginProperty(PROP_BATCH_TOKEN_EXPIRY, DEFAULT_BATCH_TOKEN_EXPIRY);
    }

    @Override
    public long getMinimumFreeSpace() {
        return this.propertiesService.getPluginProperty(PROP_MINIMUM_FREE_SPACE, 0x6400000L);
    }

    @Override
    public long getMirrorEvictionEntries() {
        return this.propertiesService.getPluginProperty(PROP_MIRROR_EVICTION_ENTRIES, 100L);
    }

    @Override
    public long getMirrorMaxInMemoryEntries() {
        return this.propertiesService.getPluginProperty(PROP_MIRROR_MAX_IN_MEMORY_ENTRIES, 10000L);
    }

    @Override
    @Nonnull
    public String getSharedSecret() {
        String sharedSecret = (String)this.pluginSettings.get(SETTING_SHARED_SECRET);
        if (sharedSecret == null) {
            sharedSecret = (String)this.transactionTemplate.execute(() -> {
                String secret = (String)this.pluginSettings.get(SETTING_SHARED_SECRET);
                if (secret == null) {
                    secret = DefaultGitLfsSettingsService.generateSharedSecret();
                    this.pluginSettings.put(SETTING_SHARED_SECRET, (Object)secret);
                }
                return secret;
            });
        }
        return sharedSecret;
    }

    @Override
    public long getStorageTokenExpiry() {
        return this.propertiesService.getPluginProperty(PROP_STORAGE_TOKEN_EXPIRY, DEFAULT_STORAGE_TOKEN_EXPIRY);
    }

    @Override
    public boolean isEnabled() {
        return this.getOrDefault(SETTING_ENABLED, true);
    }

    @Override
    public boolean isEnabled(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return (Boolean)this.transactionTemplate.execute(() -> this.configDao.isEnabled(repository));
    }

    @Override
    public void setEnabled(boolean enabled) {
        String previous = (String)this.pluginSettings.put(SETTING_ENABLED, (Object)Boolean.toString(enabled));
        if (previous == null || Boolean.parseBoolean(previous) != enabled) {
            if (enabled) {
                this.eventPublisher.publish((Object)new GitLfsFeatureEnabledEvent(this));
            } else {
                this.eventPublisher.publish((Object)new GitLfsFeatureDisabledEvent(this));
            }
        }
    }

    @Override
    public void setEnabled(@Nonnull Repository repository, boolean enabled) {
        Objects.requireNonNull(repository, "repository");
        this.transactionTemplate.execute(() -> {
            boolean previous = this.configDao.isEnabled(repository);
            this.configDao.setEnabled(repository, enabled);
            if (previous != enabled) {
                if (enabled) {
                    this.eventPublisher.publish((Object)new GitLfsEnabledEvent(this, repository));
                } else {
                    this.eventPublisher.publish((Object)new GitLfsDisabledEvent(this, repository));
                }
            }
            return null;
        });
    }

    private static String generateSharedSecret() {
        SecureRandom random = new SecureRandom();
        return new BigInteger(256, random).toString(32);
    }

    private boolean getOrDefault(String key, boolean defaultValue) {
        String val = (String)this.pluginSettings.get(key);
        if (val == null) {
            this.setEnabled(defaultValue);
            return defaultValue;
        }
        return Boolean.parseBoolean(val);
    }
}

