/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.rest.storage;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HttpRange {
    private static final Pattern RANGE_PATTERN = Pattern.compile("bytes=(?<start>\\d*)-(?<end>\\d*)");
    private final long end;
    private final long start;

    public HttpRange(long start, long end) {
        this.start = start;
        this.end = end;
    }

    @Nonnull
    public static Optional<HttpRange> parseRange(@Nullable String range) {
        Matcher matcher;
        if (range != null && (matcher = RANGE_PATTERN.matcher(range)).matches() && matcher.groupCount() == 2) {
            try {
                long start = Long.parseLong(matcher.group("start"));
                long end = Long.parseLong(matcher.group("end"));
                return Optional.of(new HttpRange(start, end));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public long getRangeStart() {
        return this.start;
    }

    public long getRangeEnd() {
        return this.end;
    }

    public String toString() {
        return String.format("%s-%s", this.start, this.end);
    }
}

