/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.model;

import com.atlassian.bitbucket.internal.scm.git.lfs.BadBatchResponseException;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.OperationType;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseAction;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class ResponseActionObject
extends ResponseObject {
    private final Map<OperationType, ResponseAction> actions = new HashMap<OperationType, ResponseAction>();

    public ResponseActionObject(@Nonnull String oid, long size, @Nonnull Collection<ResponseAction> actions) {
        super(oid, size);
        actions.forEach(action -> {
            if (this.actions.put(action.getType(), (ResponseAction)action) != null) {
                throw new BadBatchResponseException("Multiple actions with equal operation type: " + (Object)((Object)action.getType()));
            }
        });
    }

    @Nonnull
    public Collection<ResponseAction> getActions() {
        return Collections.unmodifiableCollection(this.actions.values());
    }

    @Nonnull
    public Optional<ResponseAction> getAction(@Nonnull OperationType type) {
        return Optional.ofNullable(this.actions.get((Object)Objects.requireNonNull(type, "type")));
    }
}

