/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.mirror;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LfsDigestUtils {
    private static final Logger log = LoggerFactory.getLogger(LfsDigestUtils.class);

    public static void validate(@Nonnull String calculatedChecksum, @Nonnull String desiredChecksum, @Nonnull Path objectFile) {
        Objects.requireNonNull(calculatedChecksum, "calculatedChecksum");
        Objects.requireNonNull(desiredChecksum, "desiredChecksum");
        Objects.requireNonNull(objectFile, "objectFile");
        if (!calculatedChecksum.equals(desiredChecksum)) {
            try {
                Files.delete(objectFile);
                log.warn("Deleted cached object file {} after checksum mismatch (expected SHA-256 {}, got {})", new Object[]{objectFile, desiredChecksum, calculatedChecksum});
            }
            catch (IOException e) {
                log.warn("Failed to delete cached object file {} after checksum mismatch (expected SHA-256 {}, got {})", new Object[]{objectFile, desiredChecksum, calculatedChecksum, e});
            }
        }
    }
}

