/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.jwt;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.internal.scm.git.lfs.jwt.JwtTokenGenerationException;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.jwt.CanonicalHttpRequest;
import com.atlassian.jwt.SigningAlgorithm;
import com.atlassian.jwt.core.writer.JwtClaimsBuilder;
import com.atlassian.jwt.writer.JwtJsonBuilder;
import com.atlassian.jwt.writer.JwtJsonBuilderFactory;
import com.atlassian.jwt.writer.JwtWriterFactory;
import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class GitLfsJwtHelper {
    public static final String REPO_CLAIM = "repo";
    private final AuthenticationContext authenticationContext;
    private final JwtJsonBuilderFactory jwtJsonBuilderFactory;
    private final JwtWriterFactory jwtWriterFactory;
    private final GitLfsSettingsService settingsService;

    public GitLfsJwtHelper(AuthenticationContext authenticationContext, JwtJsonBuilderFactory jwtJsonBuilderFactory, JwtWriterFactory jwtWriterFactory, GitLfsSettingsService settingsService) {
        this.authenticationContext = authenticationContext;
        this.jwtJsonBuilderFactory = jwtJsonBuilderFactory;
        this.jwtWriterFactory = jwtWriterFactory;
        this.settingsService = settingsService;
    }

    @Nonnull
    public String buildLfsApiToken(@Nonnull Repository repository, long expiry) {
        return this.buildToken("com.atlassian.bitbucket.server.bitbucket-git-lfs", null, repository, expiry);
    }

    @Nonnull
    public String buildStorageToken(@Nonnull CanonicalHttpRequest httpRequest, @Nonnull Repository repository, long expiry) {
        Objects.requireNonNull(httpRequest, "httpRequest");
        return this.buildToken("com.atlassian.bitbucket.server.bitbucket-git-lfs-storage", httpRequest, repository, expiry);
    }

    private String buildToken(String issuerName, CanonicalHttpRequest httpRequest, Repository repository, long expiry) {
        Objects.requireNonNull(repository, "repository");
        long iat = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        long exp = iat + expiry;
        JwtJsonBuilder builder = this.jwtJsonBuilderFactory.jsonBuilder().claim(REPO_CLAIM, (Object)repository.getId()).expirationTime(exp).issuedAt(iat).issuer(issuerName);
        this.addUserDetails(builder);
        if (httpRequest != null) {
            try {
                JwtClaimsBuilder.appendHttpRequestClaims((JwtJsonBuilder)builder, (CanonicalHttpRequest)httpRequest);
            }
            catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
                throw new JwtTokenGenerationException("Failed to append \"qsh\" JWT claim.", e);
            }
        }
        return "JWT " + this.jwtWriterFactory.macSigningWriter(SigningAlgorithm.HS256, this.settingsService.getSharedSecret()).jsonToJwt(builder.build());
    }

    private void addUserDetails(JwtJsonBuilder builder) {
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user == null) {
            return;
        }
        String userId = Integer.toString(user.getId());
        ImmutableMap.Builder userBuilder = ImmutableMap.builder().put((Object)"displayName", (Object)user.getDisplayName()).put((Object)"slug", (Object)user.getSlug()).put((Object)"userKey", (Object)userId).put((Object)"username", (Object)user.getName());
        builder.claim("context", (Object)ImmutableMap.of((Object)"user", (Object)userBuilder.build()));
        builder.subject(userId);
    }
}

