/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.http.lock;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.LfsHttpScmUtils;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.UpstreamLfsClient;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.http.HttpScmRequest;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletResponse;

public class MirrorLfsLockHttpScmRequest
implements HttpScmRequest {
    private final I18nService i18nService;
    private final String lockPath;
    private final Repository repository;
    private final HttpServletResponse response;
    private final UpstreamLfsClient upstreamLfsClient;

    public MirrorLfsLockHttpScmRequest(@Nonnull I18nService i18nService, @Nonnull String lockPath, @Nonnull Repository repository, @Nonnull HttpServletResponse response, @Nonnull UpstreamLfsClient upstreamLfsClient) {
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.lockPath = Objects.requireNonNull(lockPath, "lockPath");
        this.repository = Objects.requireNonNull(repository, "repository");
        this.response = Objects.requireNonNull(response, "response");
        this.upstreamLfsClient = Objects.requireNonNull(upstreamLfsClient, "upstreamLfsClient");
    }

    @Nonnull
    @VisibleForTesting
    public String getLockPath() {
        return this.lockPath;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public void handleRequest() {
        try {
            this.upstreamLfsClient.proxyLockRequest(this.lockPath, this.repository);
        }
        catch (Exception e) {
            this.sendError(this.i18nService.getMessage("bitbucket.scm.git.lfs.lock.mirror.error", new Object[0]), e.getMessage());
        }
    }

    public boolean isWrite() {
        return false;
    }

    public void sendError(@Nonnull String summary, @Nonnull String detailMessage) {
        LfsHttpScmUtils.sendError(this.response, 503, summary + "\n\n" + detailMessage);
    }
}

