/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.hook;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.hook.repository.CommitAddedDetails;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookCommitCallback;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitFilter;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.StandardRepositoryHookTrigger;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.GitLfsUtils;
import com.atlassian.bitbucket.internal.scm.git.lfs.LfsService;
import com.atlassian.bitbucket.internal.scm.git.lfs.hook.AsyncNameOnlyDiffTreeHandler;
import com.atlassian.bitbucket.internal.scm.git.lfs.hook.AsyncNameOnlyDiffTreeHandlerFactory;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockService;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AsyncCommand;
import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.GitScmCommandBuilder;
import com.atlassian.bitbucket.scm.git.hook.GitRepositoryHookTrigger;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyLfsLocksHook
implements PreRepositoryHook<RepositoryHookRequest> {
    private static final Logger log = LoggerFactory.getLogger(VerifyLfsLocksHook.class);
    private static final Set<String> IGNORED_TRIGGERS = ImmutableSet.of((Object)StandardRepositoryHookTrigger.BRANCH_CREATE.getId(), (Object)StandardRepositoryHookTrigger.BRANCH_DELETE.getId(), (Object)StandardRepositoryHookTrigger.MERGE.getId(), (Object)StandardRepositoryHookTrigger.PULL_REQUEST_MERGE.getId(), (Object)GitRepositoryHookTrigger.REBASE.getId(), (Object)StandardRepositoryHookTrigger.TAG_CREATE.getId(), (Object[])new String[]{StandardRepositoryHookTrigger.TAG_DELETE.getId()});
    private final AuthenticationContext authenticationContext;
    private final AsyncNameOnlyDiffTreeHandlerFactory diffTreeHandlerFactory;
    private final GitCommandBuilderFactory gitCommandBuilderFactory;
    private final I18nService i18nService;
    private final LfsService lfsService;
    private final LfsLockService lfsLockService;

    public VerifyLfsLocksHook(AuthenticationContext authenticationContext, AsyncNameOnlyDiffTreeHandlerFactory diffTreeHandlerFactory, GitCommandBuilderFactory gitCommandBuilderFactory, I18nService i18nService, LfsLockService lfsLockService, LfsService lfsService) {
        this.authenticationContext = authenticationContext;
        this.diffTreeHandlerFactory = diffTreeHandlerFactory;
        this.gitCommandBuilderFactory = gitCommandBuilderFactory;
        this.i18nService = i18nService;
        this.lfsLockService = lfsLockService;
        this.lfsService = lfsService;
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull RepositoryHookRequest request) {
        Repository repository = request.getRepository();
        if (VerifyLfsLocksHook.isSkippable(request) || !this.lfsService.isEnabled(repository)) {
            return RepositoryHookResult.accepted();
        }
        ApplicationUser authenticatedUser = this.authenticationContext.getCurrentUser();
        Map<String, ApplicationUser> pathsLockedByOtherUsers = this.lfsLockService.getEnforceableLocks(repository);
        if (!pathsLockedByOtherUsers.isEmpty()) {
            context.registerCommitCallback((PreRepositoryHookCommitCallback)new LockVerifyingCommitCallback(this.diffTreeHandlerFactory, this.gitCommandBuilderFactory, pathsLockedByOtherUsers, repository, authenticatedUser), RepositoryHookCommitFilter.ADDED_TO_REPOSITORY, new RepositoryHookCommitFilter[0]);
        }
        return RepositoryHookResult.accepted();
    }

    private static boolean isSkippable(RepositoryHookRequest request) {
        return IGNORED_TRIGGERS.contains(request.getTrigger().getId()) || !"git".equals(request.getRepository().getScmId()) || request.getRefChanges().stream().map(RefChange::getType).allMatch(type -> type == RefChangeType.DELETE);
    }

    private class LockVerifyingCommitCallback
    implements PreRepositoryHookCommitCallback {
        private final ApplicationUser authenticatedUser;
        private final AsyncCommand<Void> diffTreeCommand;
        private final AsyncNameOnlyDiffTreeHandler diffTreeHandler;
        private final Map<String, ApplicationUser> lockPathToOwner;
        private final Repository repository;
        private final RepositoryHookResult.Builder resultBuilder;
        private Future<Void> future;

        LockVerifyingCommitCallback(AsyncNameOnlyDiffTreeHandlerFactory asyncNameOnlyDiffTreeHandlerFactory, GitCommandBuilderFactory gitCommandBuilderFactory, Map<String, ApplicationUser> lockPathToOwner, Repository repository, ApplicationUser user) {
            this.authenticatedUser = user;
            this.diffTreeHandler = asyncNameOnlyDiffTreeHandlerFactory.create();
            this.lockPathToOwner = lockPathToOwner;
            this.repository = repository;
            this.resultBuilder = new RepositoryHookResult.Builder();
            this.diffTreeCommand = ((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)gitCommandBuilderFactory.builder(repository).command("diff-tree")).argument("-r")).argument("-c")).argument("--name-only")).argument("--no-renames")).argument("--always")).argument("--stdin")).inputHandler((CommandInputHandler)this.diffTreeHandler)).build((CommandOutputHandler)this.diffTreeHandler).asynchronous();
        }

        @Nonnull
        public RepositoryHookResult getResult() {
            return this.resultBuilder.build();
        }

        public boolean onCommitAdded(@Nonnull CommitAddedDetails commitDetails) {
            Commit commit = commitDetails.getCommit();
            if (this.future == null) {
                this.future = this.diffTreeCommand.start();
            }
            try {
                this.diffTreeHandler.processCommit(commit.getId(), path -> this.vetoCommitIfForbidden((String)path, commit));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.resultBuilder.veto(VerifyLfsLocksHook.this.i18nService.getMessage("bitbucket.scm.git.lfs.hooks.verifylocks.interrupted.summary", new Object[0]), VerifyLfsLocksHook.this.i18nService.getMessage("bitbucket.scm.git.lfs.hooks.verifylocks.interrupted.detail", new Object[0]));
                log.error("Interrupted while communicating with the git diff-tree process.", (Throwable)e);
            }
            if (this.resultBuilder.isRejected()) {
                this.terminateDiffTreeProcess();
                return false;
            }
            return true;
        }

        public void onEnd() {
            this.terminateDiffTreeProcess();
        }

        private void terminateDiffTreeProcess() {
            if (this.future != null) {
                try {
                    this.diffTreeHandler.cancel();
                    this.future.get(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.future.cancel(true);
                }
                catch (ExecutionException e) {
                    log.warn("git diff-tree process failed", (Throwable)e);
                }
                catch (TimeoutException e) {
                    this.future.cancel(true);
                }
                this.future = null;
            }
        }

        private void vetoCommitIfForbidden(String path, Commit toCommit) {
            ApplicationUser lockHolder = this.lockPathToOwner.get(path);
            if (lockHolder != null) {
                this.resultBuilder.veto(VerifyLfsLocksHook.this.i18nService.getMessage("bitbucket.scm.git.lfs.hooks.verifylocks.locked.summary", new Object[0]), VerifyLfsLocksHook.this.i18nService.getMessage("bitbucket.scm.git.lfs.hooks.verifylocks.locked.detail", new Object[]{path, GitLfsUtils.getLockOwnerName(lockHolder)}));
                log.debug("{}: {} blocked from adding commit {} as it modifies '{}' which is currently locked by {}", new Object[]{this.repository, this.authenticatedUser.getSlug(), toCommit.getId(), path, lockHolder.getSlug()});
            }
        }
    }
}

