/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.hook;

import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.io.LineReader;
import com.atlassian.bitbucket.io.LineReaderOutputHandler;
import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsyncNameOnlyDiffTreeHandler
extends LineReaderOutputHandler
implements CommandInputHandler,
CommandOutputHandler<Void> {
    protected static final String CANCEL = "@@cancel@@";
    protected static final String DIFF_TREE_END = "@@diff_tree_end@@";
    protected static final String NO_SUCH_COMMIT = "@@no_such_commit@@";
    private static final Logger log = LoggerFactory.getLogger(AsyncNameOnlyDiffTreeHandler.class);
    private final I18nService i18nService;
    private final BlockingQueue<String> commitQueue;
    private final CountDownLatch latch;
    private final BlockingQueue<String> pathQueue;
    private OutputStreamWriter inputWriter;

    AsyncNameOnlyDiffTreeHandler(I18nService i18nService) {
        super(StandardCharsets.UTF_8);
        this.i18nService = i18nService;
        this.commitQueue = new LinkedBlockingQueue<String>(1);
        this.pathQueue = new LinkedBlockingQueue<String>();
        this.latch = new CountDownLatch(1);
    }

    public void cancel() {
        this.commitQueue.offer(CANCEL);
    }

    public void complete() {
    }

    public Void getOutput() {
        return null;
    }

    public void process(OutputStream input) {
        this.inputWriter = new OutputStreamWriter(input);
        this.latch.countDown();
    }

    public void processCommit(String commitHash, Consumer<String> pathConsumer) throws InterruptedException {
        this.commitQueue.put(commitHash);
        String path = this.pathQueue.take();
        if (NO_SUCH_COMMIT.equals(path)) {
            throw new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.scm.git.lfs.hooks.verifylocks.nosuchcommit", new Object[]{commitHash}), commitHash);
        }
        while (!DIFF_TREE_END.equals(path)) {
            pathConsumer.accept(path);
            path = this.pathQueue.take();
        }
    }

    protected void processReader(LineReader reader) throws IOException {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            return;
        }
        try (OutputStreamWriter ignored = this.inputWriter;){
            String commitId;
            while (!CANCEL.equals(commitId = this.commitQueue.take())) {
                this.writeLineAndMarker(commitId);
                String line = reader.readLine();
                if (DIFF_TREE_END.equals(line)) {
                    this.pathQueue.put(NO_SUCH_COMMIT);
                    break;
                }
                do {
                    line = reader.readLine();
                    this.pathQueue.put(line);
                } while (!line.equals(DIFF_TREE_END));
            }
        }
        catch (InterruptedException e) {
            log.error("git diff-tree process interrupted while reading commits or writing paths", (Throwable)e);
        }
    }

    private void writeLineAndMarker(String line) throws IOException {
        this.inputWriter.write(line + "\n");
        this.inputWriter.write("@@diff_tree_end@@\n");
        this.inputWriter.flush();
    }
}

