/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.embedded;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.ObjectStreamingOutput;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.RangeNotSatisfiableException;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.storage.HttpRange;
import com.atlassian.bitbucket.throttle.ThrottleService;
import com.atlassian.bitbucket.throttle.Ticket;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.io.IOUtils;

public class ThrottleAwareStreamingOutput
implements ObjectStreamingOutput {
    private static final int COPY_BUFFER_SIZE = 8192;
    private final File file;
    private final HttpRange range;
    private final String resourceName;
    private final ThrottleService throttleService;

    ThrottleAwareStreamingOutput(@Nonnull File file, @Nullable HttpRange range, @Nonnull ThrottleService throttleService, @Nonnull String resourceName, @Nonnull I18nService i18nService) {
        ThrottleAwareStreamingOutput.validateRange(i18nService, file, range);
        this.file = Objects.requireNonNull(file, "file");
        this.throttleService = Objects.requireNonNull(throttleService, "throttleService");
        this.resourceName = Objects.requireNonNull(resourceName, "resourceName");
        this.range = range;
    }

    @Override
    @Nonnull
    public Optional<HttpRange> range() {
        return Optional.ofNullable(this.range);
    }

    public void write(OutputStream output) throws IOException, WebApplicationException {
        try (Ticket ignored = this.throttleService.acquireTicket(this.resourceName);
             FileInputStream input = new FileInputStream(this.file);){
            byte[] buffer = new byte[8192];
            if (this.range == null) {
                IOUtils.copyLarge((InputStream)input, (OutputStream)output, (byte[])buffer);
            } else {
                long start = this.range.getRangeStart();
                long end = Math.min(this.range.getRangeEnd(), this.file.length() - 1L);
                IOUtils.copyLarge((InputStream)input, (OutputStream)output, (long)start, (long)(end - start + 1L), (byte[])buffer);
            }
        }
    }

    private static void validateRange(I18nService i18nService, File file, HttpRange range) {
        if (range != null) {
            long end;
            long length = file.length();
            long start = range.getRangeStart();
            if (start > (end = range.getRangeEnd()) || end < 0L) {
                throw new RangeNotSatisfiableException(i18nService.createKeyedMessage("bitbucket.scm.git.lfs.http.range.invalid", new Object[]{range}));
            }
            if (start >= length || start < 0L) {
                throw new RangeNotSatisfiableException(i18nService.createKeyedMessage("bitbucket.scm.git.lfs.http.range.invalid.start", new Object[]{start, length - 1L}));
            }
        }
    }
}

