/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.embedded;

import com.atlassian.bitbucket.internal.scm.git.lfs.rest.storage.HttpRange;
import com.atlassian.bitbucket.repository.Repository;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class ReadObjectRequest {
    private final String oid;
    private final HttpRange range;
    private final Repository repository;

    private ReadObjectRequest(@Nonnull Builder builder) {
        this.oid = builder.oid;
        this.repository = builder.repository;
        this.range = builder.range;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public String getOid() {
        return this.oid;
    }

    @Nonnull
    public Optional<HttpRange> getRange() {
        return Optional.ofNullable(this.range);
    }

    public static class Builder {
        private final String oid;
        private final Repository repository;
        private HttpRange range;

        public Builder(@Nonnull Repository repository, @Nonnull String oid) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.oid = Objects.requireNonNull(oid, "oid");
        }

        public Builder range(HttpRange range) {
            this.range = range;
            return this;
        }

        @Nonnull
        public ReadObjectRequest build() {
            return new ReadObjectRequest(this);
        }
    }
}

