/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.embedded;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.AbstractEmbeddedStoreService;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.ChecksumValidationException;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.InsufficientAvailableSpaceException;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.LfsFileSystemHelper;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.ObjectStreamingOutput;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.ReadObjectRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.ThrottleAwareStreamingOutput;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.storage.HttpRange;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.throttle.ThrottleService;
import com.atlassian.bitbucket.throttle.Ticket;
import com.atlassian.bitbucket.user.SecurityService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEmbeddedStoreService
extends AbstractEmbeddedStoreService {
    private static final int COPY_BUFFER_SIZE = 8192;
    private static final Logger log = LoggerFactory.getLogger(DefaultEmbeddedStoreService.class);
    private final ThrottleService throttleService;
    private final PermissionValidationService validationService;

    public DefaultEmbeddedStoreService(@Nonnull I18nService i18nService, @Nonnull LfsFileSystemHelper lfsFileSystemHelper, @Nonnull GitLfsSettingsService settingsService, @Nonnull RepositoryService repositoryService, @Nonnull ThrottleService throttleService, @Nonnull SecurityService securityService, @Nonnull PermissionValidationService validationService) {
        super(i18nService, lfsFileSystemHelper, repositoryService, securityService, settingsService);
        this.throttleService = Objects.requireNonNull(throttleService, "throttleService");
        this.validationService = Objects.requireNonNull(validationService, "validationService");
    }

    @Override
    @Nonnull
    public ObjectStreamingOutput readObject(@Nonnull ReadObjectRequest request) {
        this.requireLfsEnabled();
        Objects.requireNonNull(request, "request");
        File file = this.lfsFileSystemHelper.getObjectPath(request.getRepository(), request.getOid()).toFile();
        HttpRange range = request.getRange().orElse(null);
        return new ThrottleAwareStreamingOutput(file, range, this.throttleService, "git-lfs", this.i18nService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(@Nonnull Repository repository, @Nonnull String oid, @Nonnull InputStream stream) throws IOException {
        this.requireLfsEnabled();
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(oid, "oid");
        Objects.requireNonNull(stream, "stream");
        try (Ticket ignored = this.throttleService.acquireTicket("git-lfs");){
            this.validationService.validateForRepository(repository, Permission.REPO_WRITE);
            Path objectFile = this.lfsFileSystemHelper.getObjectPath(repository, oid);
            if (LfsFileSystemHelper.canOpen(objectFile)) {
                return;
            }
            Path objectDir = DefaultEmbeddedStoreService.createParentDirectory(objectFile);
            Path tempFile = Files.createTempFile(objectDir, objectFile.getFileName() + "-", ".tmp", new FileAttribute[0]);
            try {
                String checksum = this.copyStreamToFileAndChecksum(stream, tempFile);
                if (!oid.equalsIgnoreCase(checksum)) {
                    log.warn("Upload failed - OID {} does not match file checksum {}", (Object)oid, (Object)checksum);
                    throw new ChecksumValidationException(this.i18nService.createKeyedMessage("bitbucket.scm.git.lfs.embeddedstore.checksum.mismatch", new Object[]{checksum}));
                }
                try {
                    Files.move(tempFile, objectFile, new CopyOption[0]);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    // empty catch block
                }
            }
            finally {
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (IOException e) {
                    log.error("Error deleting temporary LFS upload file " + tempFile, (Throwable)e);
                }
            }
        }
    }

    private static Path createParentDirectory(Path objectFile) throws IOException {
        Path dir = objectFile.getParent();
        if (dir != null && !Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        return dir;
    }

    private String copyStreamToFileAndChecksum(InputStream stream, Path file) throws IOException {
        DefaultEmbeddedStoreService.createParentDirectory(file);
        MessageDigest md = DigestUtils.getSha256Digest();
        try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
            byte[] buffer = new byte[8192];
            int len = stream.read(buffer);
            while (len != -1) {
                long usableSpace = this.lfsFileSystemHelper.getUsableSpace(file);
                if (this.lfsFileSystemHelper.getMinimumFreeSpace() > 0L && usableSpace < 8192L) {
                    log.warn("Upload failed - Insufficient available space in store. Available space is {} bytes. A free space threshold of {} bytes has been configured", (Object)usableSpace, (Object)this.lfsFileSystemHelper.getMinimumFreeSpace());
                    throw new InsufficientAvailableSpaceException(this.i18nService.createKeyedMessage("bitbucket.scm.git.lfs.embeddedstore.free.space.insufficient", new Object[0]));
                }
                out.write(buffer, 0, len);
                md.update(buffer, 0, len);
                len = stream.read(buffer);
            }
        }
        return Hex.encodeHexString((byte[])md.digest());
    }
}

