/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.embedded;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.GitLfsDisabledException;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.EmbeddedStoreService;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.LfsFileSystemHelper;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEmbeddedStoreService
implements EmbeddedStoreService {
    public static final String LFS_THROTTLE_BUCKET = "git-lfs";
    private static final Logger log = LoggerFactory.getLogger(AbstractEmbeddedStoreService.class);
    protected final I18nService i18nService;
    protected final LfsFileSystemHelper lfsFileSystemHelper;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;
    private final GitLfsSettingsService settingsService;

    public AbstractEmbeddedStoreService(I18nService i18nService, LfsFileSystemHelper lfsFileSystemHelper, RepositoryService repositoryService, SecurityService securityService, GitLfsSettingsService settingsService) {
        this.i18nService = i18nService;
        this.lfsFileSystemHelper = lfsFileSystemHelper;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
        this.settingsService = settingsService;
    }

    @Override
    public void delete(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        Page related = (Page)this.securityService.withPermission(Permission.REPO_READ, "Finding related repositories").call(() -> this.repositoryService.findRelated(repository, PageUtils.newRequest((int)0, (int)1)));
        if (related.getSize() == 0 && related.getIsLastPage()) {
            String hierarchyId = repository.getHierarchyId();
            try {
                log.debug("Deleting LFS content for hierarchy {}", (Object)hierarchyId);
                FileUtils.deleteDirectory((File)this.lfsFileSystemHelper.getHierarchyPath(repository).toFile());
            }
            catch (IOException e) {
                log.error("Failed to delete LFS content for hierarchy {}", (Object)hierarchyId, (Object)e);
            }
        }
    }

    @Override
    public long getUsableSpace(@Nonnull Repository repository) {
        return this.lfsFileSystemHelper.getUsableSpace(repository);
    }

    @Override
    public boolean objectExists(@Nonnull Repository repository, @Nonnull String oid) {
        return this.lfsFileSystemHelper.objectExists(repository, oid);
    }

    protected void requireLfsEnabled() {
        if (!this.settingsService.isEnabled()) {
            throw new GitLfsDisabledException(this.i18nService.createKeyedMessage("bitbucket.scm.git.lfs.disabled", new Object[0]));
        }
    }
}

