/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.dao.v1;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.internal.scm.git.lfs.dao.AoGitLfsRepositoryConfig;
import com.atlassian.bitbucket.internal.scm.git.lfs.dao.v0.AoLfsLockV0;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import net.java.ao.Accessor;
import net.java.ao.Mutator;
import net.java.ao.Preload;
import net.java.ao.Query;
import net.java.ao.schema.Table;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateToV1Task
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(MigrateToV1Task.class);

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"1");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects ao) {
        log.debug("Attempting lfs locks data upgrade on model version {}", (Object)modelVersion.toString());
        Preconditions.checkState((boolean)modelVersion.isSame(ModelVersion.valueOf((String)"0")), (Object)"This task can only upgrade from version 0 to 1");
        log.info("Starting to migrate lfs locks model data");
        ao.migrate(new Class[]{AoLfsLockMigrationModel.class, AoGitLfsRepositoryConfig.class});
        PageUtils.toStream(pageRequest -> this.pageQuery(ao, pageRequest), (int)100).forEach(lock -> {
            lock.setDirectoryHash(DigestUtils.sha256Hex((String)FilenameUtils.getPathNoEndSeparator((String)lock.getPath())));
            lock.save();
        });
        log.info("Migration of lfs locks model data is complete");
    }

    private Page<AoLfsLockMigrationModel> pageQuery(ActiveObjects ao, PageRequest pageRequest) {
        Query query = AoUtils.restrict((Query)Query.select().order("ID"), (PageRequest)pageRequest);
        return PageUtils.createPage(Arrays.asList(ao.find(AoLfsLockMigrationModel.class, query)), (PageRequest)pageRequest);
    }

    @Preload(value={"DIRECTORY_HASH"})
    @Table(value="GIT_LFS_LOCK")
    static interface AoLfsLockMigrationModel
    extends AoLfsLockV0 {
        @Accessor(value="DIRECTORY_HASH")
        public String getDirectoryHash();

        @Mutator(value="DIRECTORY_HASH")
        public void setDirectoryHash(String var1);
    }
}

