/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.protocol;

import com.atlassian.bitbucket.scm.git.protocol.GitPacketStreamAnalyzer;
import com.atlassian.bitbucket.scm.git.protocol.GitPackets;
import com.atlassian.bitbucket.scm.git.protocol.GitScmRequestType;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class UploadPackRequestAnalyzer
extends GitPacketStreamAnalyzer {
    private Set<String> commands = new LinkedHashSet<String>();
    private boolean foundDeepen;
    private boolean foundDone;
    private boolean foundFlush;
    private boolean foundHave;
    private boolean foundWant;

    public UploadPackRequestAnalyzer() {
        this.addListener(packet -> {
            if (packet.length < 4) {
                return;
            }
            if (GitPackets.isFlush(packet)) {
                this.foundFlush = true;
            } else {
                String line = GitPackets.toLine(packet);
                if (line.startsWith("want ")) {
                    this.foundWant = true;
                } else if (line.startsWith("have ")) {
                    this.foundHave = true;
                } else if (line.startsWith("command=")) {
                    this.commands.add(line.substring(8).trim());
                } else if (line.startsWith("done")) {
                    this.foundDone = true;
                } else if (line.startsWith("deepen")) {
                    this.foundDeepen = true;
                }
            }
        });
    }

    @Nonnull
    public GitScmRequestType getType() {
        if (this.commands.isEmpty() || this.commands.contains("fetch")) {
            if (!this.foundWant) {
                return this.foundFlush ? GitScmRequestType.REFS : GitScmRequestType.UNKNOWN;
            }
            if (this.foundHave) {
                return this.foundDeepen ? GitScmRequestType.SHALLOW_FETCH : GitScmRequestType.FETCH;
            }
            if (this.foundDeepen && !this.foundDone) {
                return GitScmRequestType.NEGOTIATION;
            }
            return this.foundDeepen ? GitScmRequestType.SHALLOW_CLONE : GitScmRequestType.CLONE;
        }
        if (this.commands.contains("ls-refs")) {
            return GitScmRequestType.REFS;
        }
        return GitScmRequestType.UNKNOWN;
    }

    @Override
    public boolean isDone() {
        return this.foundDone;
    }
}

