/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.protocol;

import com.atlassian.bitbucket.scm.git.protocol.GitPacketStreamAnalyzer;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReceivePackRequestAnalyzer
extends GitPacketStreamAnalyzer {
    private static final Pattern REF_CHANGE_COMMAND = Pattern.compile("([0-9a-z]{40}) ([0-9a-z]{40}) (.*)");
    private boolean done;
    private boolean shallow;
    private boolean signed;
    private boolean update;

    public ReceivePackRequestAnalyzer() {
        this.addListener(packet -> {
            if (packet.length < 4) {
                return;
            }
            String line = new String(packet, StandardCharsets.UTF_8);
            if (line.equals("0000") || line.startsWith("push-cert-end")) {
                this.done = true;
            } else if ((line = line.substring(4)).startsWith("push-cert")) {
                this.signed = true;
            } else if (line.startsWith("shallow ")) {
                this.shallow = true;
            } else {
                Matcher matcher = REF_CHANGE_COMMAND.matcher(line);
                if (matcher.matches()) {
                    this.update = true;
                }
            }
        });
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isShallow() {
        return this.shallow;
    }

    public boolean isUpdate() {
        return this.update;
    }
}

