/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.worktree;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.scm.git.worktree.GitWorkTree;
import com.atlassian.bitbucket.scm.git.worktree.GitWorkTreeRepositoryHookInvoker;
import com.atlassian.event.api.EventPublisher;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class AbstractGitWorkTreeRepositoryHookInvoker<T extends RepositoryHookRequest>
implements GitWorkTreeRepositoryHookInvoker {
    protected final EventPublisher eventPublisher;
    private final RepositoryHookService repositoryHookService;

    public AbstractGitWorkTreeRepositoryHookInvoker(@Nonnull EventPublisher eventPublisher, @Nonnull RepositoryHookService repositoryHookService) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher, "eventPublisher");
        this.repositoryHookService = Objects.requireNonNull(repositoryHookService, "repositoryHookService");
    }

    @Override
    public boolean preUpdate(@Nonnull GitWorkTree workTree, @Nonnull List<RefChange> refChanges) {
        T request = this.createHookRequest(workTree, refChanges);
        RepositoryHookResult result = this.repositoryHookService.preUpdate(request);
        if (result.isAccepted()) {
            this.onAccepted(request, result);
            return true;
        }
        this.onRejected(request, result);
        return false;
    }

    @Override
    public void postUpdate(@Nonnull GitWorkTree workTree, @Nonnull List<RefChange> refChanges) {
        T request = this.createHookRequest(workTree, refChanges);
        this.repositoryHookService.postUpdate(request);
        this.eventPublisher.publish((Object)this.createPostUpdateEvent(request));
    }

    @Nonnull
    protected abstract T createHookRequest(@Nonnull GitWorkTree var1, @Nonnull List<RefChange> var2);

    @Nonnull
    protected abstract ApplicationEvent createPostUpdateEvent(@Nonnull T var1);

    protected void onAccepted(@Nonnull T hookRequest, @Nonnull RepositoryHookResult result) {
    }

    protected void onRejected(@Nonnull T hookRequest, @Nonnull RepositoryHookResult result) {
    }
}

