/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.user;

import com.atlassian.bitbucket.dmz.user.LicenseStatus;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DetailedUserSearchRequest {
    private final String directoryName;
    private final String filterText;
    private final Long lastActiveAfter;
    private final Long lastActiveBefore;
    private final LicenseStatus licenseStatus;

    public DetailedUserSearchRequest(Builder builder) {
        this.directoryName = builder.directoryName;
        this.filterText = builder.filterText;
        this.lastActiveAfter = builder.lastActiveAfter;
        this.lastActiveBefore = builder.lastActiveBefore;
        this.licenseStatus = builder.licenseStatus;
    }

    @Nonnull
    public Optional<String> getDirectoryName() {
        return Optional.ofNullable(this.directoryName);
    }

    @Nonnull
    public Optional<String> getFilterText() {
        return Optional.ofNullable(this.filterText);
    }

    @Nonnull
    public Optional<Long> getLastActiveAfter() {
        return Optional.ofNullable(this.lastActiveAfter);
    }

    @Nonnull
    public Optional<Long> getLastActiveBefore() {
        return Optional.ofNullable(this.lastActiveBefore);
    }

    @Nonnull
    public Optional<LicenseStatus> getLicenseStatus() {
        return Optional.ofNullable(this.licenseStatus);
    }

    public static class Builder {
        private String directoryName;
        private String filterText;
        private Long lastActiveAfter;
        private Long lastActiveBefore;
        private LicenseStatus licenseStatus;

        @Nonnull
        public DetailedUserSearchRequest build() {
            return new DetailedUserSearchRequest(this);
        }

        @Nonnull
        public Builder directoryName(@Nullable String value) {
            this.directoryName = value;
            return this;
        }

        @Nonnull
        public Builder filterText(@Nullable String value) {
            this.filterText = value;
            return this;
        }

        @Nonnull
        public Builder lastActiveAfter(@Nullable Long value) {
            this.lastActiveAfter = value;
            return this;
        }

        @Nonnull
        public Builder lastActiveBefore(@Nullable Long value) {
            this.lastActiveBefore = value;
            return this;
        }

        @Nonnull
        public Builder licenseStatus(@Nullable LicenseStatus value) {
            this.licenseStatus = value;
            return this;
        }
    }
}

