/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.secretscanning.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.dmz.secretscanning.scan.SecretLocation;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.event.repository.RepositoryEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.AsynchronousPreferred;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AsynchronousPreferred
@TransactionAware
@EventName(value="stash.secretscanning.secret.found")
public class SecretsDetectedEvent
extends RepositoryEvent {
    private final List<SecretLocation> secretLocations;
    private final ApplicationUser initiatingUser;

    public SecretsDetectedEvent(@Nonnull Repository repository, @Nonnull List<SecretLocation> secretLocations, @Nullable ApplicationUser initiatingUser, @Nonnull Object source) {
        super(source, repository);
        this.secretLocations = Objects.requireNonNull(secretLocations, "secretLocations");
        this.initiatingUser = initiatingUser;
    }

    public List<SecretLocation> getSecretLocations() {
        return this.secretLocations;
    }

    @Nullable
    public ApplicationUser getInitiatingUser() {
        return this.initiatingUser;
    }
}

