/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.migration;

import com.atlassian.bitbucket.dmz.migration.MeshMigrationJob;
import com.atlassian.bitbucket.dmz.migration.MeshMigrationJobState;
import com.atlassian.bitbucket.dmz.migration.MeshMigrationQueueState;
import com.google.common.collect.ImmutableSortedMap;
import java.time.Instant;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class MeshMigrationSummary {
    private final Instant endTime;
    private final long jobId;
    private final long maxBandwidth;
    private final int progressPercentage;
    private final Map<MeshMigrationQueueState, Long> queueCountByState;
    private final Instant startTime;
    private final MeshMigrationJobState state;

    private MeshMigrationSummary(Builder builder) {
        this.endTime = builder.endTime;
        this.jobId = builder.jobId;
        this.maxBandwidth = builder.maxBandwidth;
        this.progressPercentage = builder.progressPercentage;
        this.queueCountByState = ImmutableSortedMap.copyOf((Map)builder.queueCountByState, Comparator.comparing(MeshMigrationQueueState::getId));
        this.startTime = builder.startTime;
        this.state = builder.state;
    }

    @Nonnull
    public Optional<Instant> getEndTime() {
        return Optional.ofNullable(this.endTime);
    }

    public long getJobId() {
        return this.jobId;
    }

    public long getMaxBandwidth() {
        return this.maxBandwidth;
    }

    public int getProgressPercentage() {
        return this.progressPercentage;
    }

    @Nonnull
    public Map<MeshMigrationQueueState, Long> getQueueCountByState() {
        return this.queueCountByState;
    }

    @Nonnull
    public Instant getStartTime() {
        return this.startTime;
    }

    @Nonnull
    public MeshMigrationJobState getState() {
        return this.state;
    }

    public static class Builder {
        private final Instant endTime;
        private final long jobId;
        private final long maxBandwidth;
        private final Map<MeshMigrationQueueState, Long> queueCountByState = new HashMap<MeshMigrationQueueState, Long>();
        private final Instant startTime;
        private final MeshMigrationJobState state;
        private int progressPercentage;

        public Builder(@Nonnull MeshMigrationJob value) {
            Objects.requireNonNull(value, "job");
            this.endTime = value.getEndTime().orElse(null);
            this.jobId = value.getInternalJobId();
            this.maxBandwidth = value.getMaxBandwidth();
            this.startTime = value.getStartTime();
            this.state = value.getState();
        }

        public Builder(@Nonnull MeshMigrationSummary value) {
            Objects.requireNonNull(value, "meshMigrationSummary");
            this.endTime = value.getEndTime().orElse(null);
            this.jobId = value.getJobId();
            this.maxBandwidth = value.getMaxBandwidth();
            this.progressPercentage = value.getProgressPercentage();
            this.queueCountByState.putAll(value.getQueueCountByState());
            this.startTime = value.getStartTime();
            this.state = value.getState();
        }

        @Nonnull
        public MeshMigrationSummary build() {
            return new MeshMigrationSummary(this);
        }

        @Nonnull
        public Builder queueCountByState(@Nonnull Map<MeshMigrationQueueState, Long> value) {
            this.queueCountByState.putAll(Objects.requireNonNull(value, "queueCountByState"));
            return this;
        }

        @Nonnull
        public Builder progressPercentage(int value) {
            this.progressPercentage = value;
            return this;
        }
    }
}

