/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.discovery;

import com.atlassian.bitbucket.util.Version;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;

public enum DiscoverableFeature {
    AUTO_DECLINE("feature.discovery.auto-decline.discovered", null, new Version(new Integer[]{7, 7})),
    AUTO_MERGE("feature.discovery.auto-merge.discovered", null, new Version(new Integer[]{8, 15})),
    BUILDS_PAGE("feature.discovery.builds-page.discovered", null, new Version(new Integer[]{7, 4})),
    COMMIT_REVIEW("feature.discovery.commit-level-review.discovered", null, new Version(new Integer[]{4, 8})),
    DEFAULT_TASKS("feature.discovery.default-tasks.discovered", null, new Version(new Integer[]{8, 4})),
    EFFECTIVE_PERMISSIONS("feature.discovery.effective-permissions.discovered", null, new Version(new Integer[]{8, 5})),
    JIRA_COMMIT_CHECKER("feature.discovery.jira-commit-checker.discovered", null, new Version(new Integer[]{7, 16})),
    KEYS_TOKENS("feature.discovery.keys-tokens.discovered", null, new Version(new Integer[]{8, 7})),
    NEEDS_WORK("feature.discovery.needs-work.discovered", "SEEN_NEEDS_WORK_DISCOVERY", new Version(new Integer[]{4, 4})),
    POLICIES("feature.discovery.policies.discovered", null, new Version(new Integer[]{7, 5})),
    PROJECT_REPO_ACCESS_TOKENS("feature.discovery.project-repo-access-tokens.discovered", null, new Version(new Integer[]{7, 18})),
    PROJECT_SECRET_SCANNING("feature.discovery.project-secret-scanning.discovered", null, new Version(new Integer[]{8, 5})),
    PULL_REQUEST_TEMPLATES("feature.discovery.pull-request-templates.discovered", null, new Version(new Integer[]{7, 13})),
    REPO_SECRET_SCANNING("feature.discovery.repo-secret-scanning.discovered", null, new Version(new Integer[]{8, 5})),
    REQUIRED_BUILDS("feature.discovery.required-builds.discovered", null, new Version(new Integer[]{7, 14})),
    REVIEWER_GROUPS("feature.discovery.reviewer-groups.discovered", null, new Version(new Integer[]{7, 13})),
    WEBHOOKS("feature.discovery.webhooks.discovered", null, new Version(new Integer[]{8, 8}));

    private final String key;
    private final String legacyKey;
    private final Version version;

    private DiscoverableFeature(String key, String legacyKey, Version version) {
        this.key = key;
        this.legacyKey = legacyKey;
        this.version = version;
    }

    public static Optional<DiscoverableFeature> fromName(String name) {
        if (name == null) {
            return Optional.empty();
        }
        return Arrays.stream(DiscoverableFeature.values()).filter(result -> name.equals(result.name())).findAny();
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public Version getVersion() {
        return this.version;
    }

    @Nonnull
    public Optional<String> getLegacyKey() {
        return Optional.ofNullable(this.legacyKey);
    }
}

