/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.codeowners;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class CodeOwnersResponse {
    private final List<ApplicationUser> codeOwners;
    private final List<String> errorMessages;

    private CodeOwnersResponse(Builder builder) {
        this.codeOwners = builder.codeOwners;
        this.errorMessages = builder.errorMessages.build();
    }

    @Nonnull
    public List<ApplicationUser> getCodeOwners() {
        return this.codeOwners;
    }

    @Nonnull
    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public static class Builder {
        private final List<ApplicationUser> codeOwners;
        private final ImmutableList.Builder<String> errorMessages = new ImmutableList.Builder();

        public Builder(@Nonnull List<ApplicationUser> codeOwners) {
            this.codeOwners = Objects.requireNonNull(codeOwners, "codeOwners");
        }

        public Builder(@Nonnull String errorMessage) {
            this.codeOwners = Collections.emptyList();
            this.errorMessages.add((Object)Objects.requireNonNull(errorMessage, "errorMessage"));
        }

        @Nonnull
        public CodeOwnersResponse build() {
            return new CodeOwnersResponse(this);
        }

        @Nonnull
        public Builder errorMessage(@Nonnull String errorMessage) {
            this.errorMessages.add((Object)Objects.requireNonNull(errorMessage, "errorMessage"));
            return this;
        }
    }
}

