/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.build.status;

import com.atlassian.bitbucket.dmz.build.status.AbstractBuildStatusSummaryRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;

public class AbstractBulkCommitBuildStatusSummaryRequest
extends AbstractBuildStatusSummaryRequest {
    private final Collection<String> commitIds;

    protected AbstractBulkCommitBuildStatusSummaryRequest(AbstractBuilder<?> builder) {
        super(builder);
        this.commitIds = ((AbstractBuilder)builder).commitIds.build();
    }

    @Nonnull
    public Collection<String> getCommitIds() {
        return this.commitIds;
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T>>
    extends AbstractBuildStatusSummaryRequest.AbstractBuilder<T> {
        private final ImmutableList.Builder<String> commitIds = new ImmutableList.Builder();

        public AbstractBuilder(@Nonnull Repository repository, String ... commitIds) {
            super(Objects.requireNonNull(repository, "repository"));
            this.commitIds.addAll(Arrays.asList(commitIds));
        }

        public AbstractBuilder(@Nonnull AbstractBulkCommitBuildStatusSummaryRequest request) {
            super(Objects.requireNonNull(request, "request"));
            this.commitIds.addAll(request.getCommitIds());
        }

        @Override
        @Nonnull
        public AbstractBulkCommitBuildStatusSummaryRequest build() {
            return new AbstractBulkCommitBuildStatusSummaryRequest(this);
        }

        public T commitId(@Nonnull String commitId) {
            this.commitIds.add((Object)AbstractBuilder.requireNonBlank((String)commitId, (String)"commitId"));
            return (T)((Object)((AbstractBuilder)((Object)this.self())));
        }

        public T commitIds(@Nonnull Collection<String> commitIds) {
            this.commitIds.addAll((Iterable)Objects.requireNonNull(commitIds, "commitIds"));
            return (T)((Object)((AbstractBuilder)((Object)this.self())));
        }
    }
}

