/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.admin.banner;

import com.atlassian.bitbucket.dmz.admin.banner.AnnouncementBannerAudience;
import com.atlassian.bitbucket.util.BuilderSupport;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SetAnnouncementBannerRequest {
    private final AnnouncementBannerAudience audience;
    private final boolean enabled;
    private final String message;

    protected SetAnnouncementBannerRequest(Builder builder) {
        this.audience = builder.audience;
        this.enabled = builder.enabled;
        this.message = builder.message;
    }

    @Nonnull
    public AnnouncementBannerAudience getAudience() {
        return this.audience;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nonnull
    public String getMessage() {
        return this.message;
    }

    public static class Builder
    extends BuilderSupport {
        private String message;
        private AnnouncementBannerAudience audience;
        private boolean enabled;

        protected Builder(@Nonnull String message, @Nonnull AnnouncementBannerAudience audience, boolean enabled) {
            this.audience = audience;
            this.enabled = enabled;
            this.message = message;
        }

        public Builder() {
        }

        public Builder audience(@Nonnull AnnouncementBannerAudience audience) {
            this.audience = Objects.requireNonNull(audience, "audience");
            return this.self();
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this.self();
        }

        public Builder message(@Nonnull String message) {
            this.message = Builder.requireNonBlank((String)message, (String)"message");
            return this.self();
        }

        @Nonnull
        public SetAnnouncementBannerRequest build() {
            return new SetAnnouncementBannerRequest(this);
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

