/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.suggestion;

import com.atlassian.bitbucket.pull.PullRequest;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ApplySuggestionRequest {
    private final long commentId;
    private final int commentVersion;
    private final String commitMessage;
    private final PullRequest pullRequest;
    private final int pullRequestVersion;
    private final int suggestionIndex;

    private ApplySuggestionRequest(Builder builder) {
        this.commentId = builder.commentId;
        this.commentVersion = Objects.requireNonNull(builder.commentVersion, "commentVersion");
        this.commitMessage = Objects.requireNonNull(builder.commitMessage, "commitMessage");
        this.pullRequest = Objects.requireNonNull(builder.pullRequest, "pullRequest");
        this.pullRequestVersion = Objects.requireNonNull(builder.pullRequestVersion, "pullRequestVersion");
        this.suggestionIndex = Objects.requireNonNull(builder.suggestionIndex, "suggestionIndex");
    }

    public long getCommentId() {
        return this.commentId;
    }

    public int getCommentVersion() {
        return this.commentVersion;
    }

    @Nonnull
    public String getCommitMessage() {
        return this.commitMessage;
    }

    @Nonnull
    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    public int getPullRequestVersion() {
        return this.pullRequestVersion;
    }

    public int getSuggestionIndex() {
        return this.suggestionIndex;
    }

    public static class Builder {
        private final long commentId;
        private final PullRequest pullRequest;
        private Integer commentVersion;
        private String commitMessage;
        private Integer pullRequestVersion;
        private Integer suggestionIndex;

        public Builder(long commentId, PullRequest pullRequest) {
            this.commentId = commentId;
            this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
        }

        @Nonnull
        public ApplySuggestionRequest build() {
            return new ApplySuggestionRequest(this);
        }

        @Nonnull
        public Builder commentVersion(int value) {
            this.commentVersion = value;
            return this;
        }

        @Nonnull
        public Builder commitMessage(@Nonnull String value) {
            this.commitMessage = Objects.requireNonNull(value, "commitMessage");
            return this;
        }

        @Nonnull
        public Builder pullRequestVersion(int value) {
            this.pullRequestVersion = value;
            return this;
        }

        @Nonnull
        public Builder suggestionIndex(int value) {
            this.suggestionIndex = value;
            return this;
        }
    }
}

