/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.repository;

import com.atlassian.bitbucket.dmz.server.DataStore;
import com.atlassian.bitbucket.repository.Repository;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface DmzRepository
extends Repository {
    public static int getPartition(@Nullable Repository repository) {
        if (repository instanceof DmzRepository) {
            return ((DmzRepository)repository).getPartition();
        }
        return -1;
    }

    public static boolean isLocal(@Nullable Repository repository) {
        return !DmzRepository.isRemote(repository);
    }

    public static boolean isReadOnly(@Nullable Repository repository) {
        return repository instanceof DmzRepository && ((DmzRepository)repository).isReadOnly();
    }

    public static boolean isRemote(@Nullable Repository repository) {
        return repository instanceof DmzRepository && ((DmzRepository)repository).isRemote();
    }

    @Nonnull
    public Optional<? extends DataStore> getDataStore();

    public int getPartition();

    public boolean isOffline();

    public boolean isReadOnly();

    public boolean isRemote();
}

