/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.pull;

import com.atlassian.bitbucket.dmz.pull.PullRequestSummaryField;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestSummaryRequest {
    private final Set<PullRequestSummaryField> fields;
    private final boolean onlyClosed;
    private final int repositoryId;

    private PullRequestSummaryRequest(Builder builder) {
        this.fields = builder.fields.build();
        this.onlyClosed = builder.onlyClosed;
        this.repositoryId = builder.repositoryId;
    }

    @Nonnull
    public Set<PullRequestSummaryField> getFields() {
        return this.fields;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public boolean isOnlyClosed() {
        return this.onlyClosed;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<PullRequestSummaryField> fields;
        private final int repositoryId;
        private boolean onlyClosed;

        public Builder(@Nonnull Repository repository) {
            this(Objects.requireNonNull(repository, "repository").getId());
        }

        public Builder(int repositoryId) {
            this.repositoryId = repositoryId;
            this.fields = ImmutableSet.builder();
        }

        @Nonnull
        public PullRequestSummaryRequest build() {
            return new PullRequestSummaryRequest(this);
        }

        @Nonnull
        public Builder field(@Nullable PullRequestSummaryField value) {
            Builder.addIf(Objects::nonNull, this.fields, (Object)((Object)value));
            return this;
        }

        @Nonnull
        public Builder fields(@Nullable Iterable<PullRequestSummaryField> values) {
            Builder.addIf(Objects::nonNull, this.fields, values);
            return this;
        }

        @Nonnull
        public Builder fields(@Nullable PullRequestSummaryField value, PullRequestSummaryField ... values) {
            Builder.addIf(Objects::nonNull, this.fields, (Object)((Object)value), (Object[])values);
            return this;
        }

        @Nonnull
        public Builder onlyClosed(boolean value) {
            this.onlyClosed = value;
            return this;
        }
    }
}

