/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.ratelimit;

import com.atlassian.bitbucket.dmz.ratelimit.AggregateRejectCounterOrder;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AggregateRejectCounterSearchRequest {
    private final String filter;
    private final AggregateRejectCounterOrder sortOrder;

    private AggregateRejectCounterSearchRequest(Builder builder) {
        this.filter = builder.filter;
        this.sortOrder = builder.sortOrder;
    }

    @Nullable
    public String getFilter() {
        return this.filter;
    }

    @Nonnull
    public AggregateRejectCounterOrder getOrder() {
        return this.sortOrder;
    }

    public static class Builder {
        private String filter;
        private AggregateRejectCounterOrder sortOrder;

        public Builder() {
            this.sortOrder = AggregateRejectCounterOrder.FREQUENCY;
        }

        public Builder(@Nonnull AggregateRejectCounterSearchRequest request) {
            Objects.requireNonNull(request, "request");
            this.filter = request.filter;
            this.sortOrder = request.sortOrder;
        }

        @Nonnull
        public AggregateRejectCounterSearchRequest build() {
            return new AggregateRejectCounterSearchRequest(this);
        }

        @Nonnull
        public Builder filter(@Nullable String filter) {
            this.filter = StringUtils.trimToNull((String)filter);
            return this;
        }

        @Nonnull
        public Builder sort(@Nullable AggregateRejectCounterOrder sort) {
            this.sortOrder = sort;
            return this;
        }
    }
}

