/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import liquibase.database.structure.type.CharType;
import liquibase.database.structure.type.CustomType;
import liquibase.database.structure.type.DataType;
import liquibase.database.typeconversion.core.OracleTypeConverter;

public class CustomOracleTypeConverter
extends OracleTypeConverter {
    private static Set<String> FORCE_CHARS = ImmutableSet.of((Object)"VARCHAR", (Object)"VARCHAR2", (Object)"NVARCHAR", (Object)"NVARCHAR2", (Object)"CHAR");

    public int getPriority() {
        return 10;
    }

    protected DataType getDataType(String columnTypeString, Boolean autoIncrement, String dataTypeName, String precision, String additionalInformation) {
        DataType returnTypeName = super.getDataType(columnTypeString, autoIncrement, dataTypeName, precision, additionalInformation);
        if (returnTypeName instanceof CustomType) {
            boolean returnTypeChanged = false;
            if (columnTypeString.toUpperCase().startsWith("CHARACTER")) {
                returnTypeName = new CharType();
                returnTypeChanged = true;
            }
            if (returnTypeChanged) {
                this.addPrecisionToType(precision, returnTypeName);
            }
        }
        if (returnTypeName.getDataTypeName() != null && FORCE_CHARS.contains(returnTypeName.getDataTypeName())) {
            returnTypeName.setUnit("CHAR");
        }
        return returnTypeName;
    }
}

