/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalServiceUser;
import com.atlassian.stash.internal.user.InternalStashUserVisitor;
import com.atlassian.stash.internal.user.InternalUserSettings;
import com.atlassian.stash.internal.user.StashUserDao;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="stashUserDao")
public class HibernateStashUserDao
extends AbstractHibernateDao<Integer, InternalApplicationUser>
implements StashUserDao {
    private static final Logger log = LoggerFactory.getLogger(HibernateStashUserDao.class);
    @VisibleForTesting
    static final String USER_SETTINGS = String.format("{\"%s\":true,\"%s\":true}", "SHOW_GETTING_STARTED_PAGE", "SEEN_NEEDS_WORK_DISCOVERY");
    private static final String FIELD_ACTIVE = "active";
    private static final String FIELD_DELETED_DATE = "deletedDate";
    private static final String FIELD_DISPLAY_NAME = "displayName";
    private static final String FIELD_SLUG = "slug";
    private static final String FIELD_USERNAME = "username";
    private static final int MAX_USERNAME_LENGTH = 255;
    private static final Function<String, String> FORMAT_USERNAME = IdentifierUtils::toLowerCase;
    private final SecureTokenGenerator tokenGenerator;

    @Autowired
    public HibernateStashUserDao(SessionFactory sessionFactory, SecureTokenGenerator tokenGenerator) {
        super(sessionFactory);
        this.tokenGenerator = tokenGenerator;
    }

    @Nonnull
    public InternalNormalUser archive(@Nonnull InternalNormalUser user) {
        String archivedSlug;
        Preconditions.checkArgument((!((InternalNormalUser)Preconditions.checkNotNull((Object)user, (Object)"user")).isCrowdBacked() ? 1 : 0) != 0, (Object)"Only deleted users can be archived");
        int counter = 0;
        String suffix = "_ar";
        String archivedName = this.safeAppendSuffix(user.getName(), 255, suffix);
        while (this.findByName(archivedName) != null && ++counter < 100) {
            suffix = "_ar" + counter;
            archivedName = this.safeAppendSuffix(user.getName(), 255, suffix);
        }
        if (counter == 100) {
            archivedName = this.tokenGenerator.generateToken();
            while (this.findByName(archivedName) != null) {
                archivedName = this.tokenGenerator.generateToken();
            }
            archivedSlug = this.generateUniqueSlugForUser(archivedName, user.getType(), (InternalApplicationUser)user);
        } else {
            archivedSlug = this.generateUniqueSlugForUser(this.safeAppendSuffix(user.getName(), 126, suffix), user.getType(), (InternalApplicationUser)user);
        }
        log.info("Archiving user {} with slug {} to {}/{}", new Object[]{user.getName(), user.getSlug(), archivedName, archivedSlug});
        return this.update(((InternalNormalUser.Builder)((InternalNormalUser.Builder)user.copy().name(archivedName)).slug(archivedSlug)).build());
    }

    @Override
    @Nonnull
    public InternalNormalUser create(@Nonnull InternalNormalUser user) {
        String slug = this.generateUniqueSlug(user.getName(), UserType.NORMAL);
        return (InternalNormalUser)((InternalApplicationUser)super.create(((InternalNormalUser.Builder)user.copy().slug(slug)).build())).accept((InternalStashUserVisitor)InternalNormalUser.TO_NORMAL_USER);
    }

    @Override
    @Nonnull
    public InternalServiceUser create(@Nonnull InternalServiceUser user) {
        String slug = this.generateUniqueSlug(user.getName(), UserType.SERVICE);
        return (InternalServiceUser)((InternalApplicationUser)super.create(((InternalServiceUser.Builder)user.copy().slug(slug)).build())).accept((InternalStashUserVisitor)InternalServiceUser.TO_SERVICE_USER);
    }

    @Override
    public InternalApplicationUser create(@Nonnull InternalApplicationUser user) {
        Preconditions.checkNotNull((Object)user, (Object)"user");
        return (InternalApplicationUser)user.accept((InternalStashUserVisitor)new InternalStashUserVisitor<InternalApplicationUser>(){

            public InternalApplicationUser visit(@Nonnull InternalNormalUser user) {
                return HibernateStashUserDao.this.create(user);
            }

            public InternalApplicationUser visit(@Nonnull InternalServiceUser user) {
                return HibernateStashUserDao.this.create(user);
            }
        });
    }

    @Override
    @Nonnull
    public Page<InternalApplicationUser> findAll(@Nonnull PageRequest pageRequest) {
        return this.findAll(UserType.NORMAL, pageRequest);
    }

    @Nonnull
    public Page<InternalApplicationUser> findAll(@Nonnull UserType userType, @Nonnull PageRequest pageRequest) {
        Criteria criteria = this.session().createCriteria(this.userClassForType(userType)).addOrder(this.orderFor(userType));
        if (userType == UserType.SERVICE) {
            criteria.add((Criterion)Restrictions.eq((String)FIELD_ACTIVE, (Object)true));
        }
        return this.pageCriteria(criteria, pageRequest);
    }

    @Override
    @Nonnull
    public Page<InternalApplicationUser> findAll(@Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalApplicationUser> predicate) {
        return this.findAll(UserType.NORMAL, pageRequest, predicate);
    }

    @Nonnull
    public Page<InternalApplicationUser> findAll(@Nonnull UserType userType, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalApplicationUser> predicate) {
        Criteria criteria = this.session().createCriteria(this.userClassForType(userType)).addOrder(this.orderFor(userType));
        return this.pageCriteria(criteria, pageRequest, predicate);
    }

    public InternalNormalUser findByName(@Nonnull String username) {
        return (InternalNormalUser)this.session().createQuery("from InternalNormalUser where username = :username").setParameter(FIELD_USERNAME, (Object)FORMAT_USERNAME.apply(username)).uniqueResult();
    }

    public InternalNormalUser findBySlug(@Nonnull String slug) {
        return (InternalNormalUser)this.session().createQuery("from InternalNormalUser where slug = :slug").setParameter(FIELD_SLUG, (Object)slug).uniqueResult();
    }

    @Nonnull
    public Set<InternalNormalUser> findByNames(@Nonnull Set<String> usernames) {
        if (usernames.isEmpty()) {
            return Collections.emptySet();
        }
        Query query = this.session().createQuery("from InternalNormalUser where username in (:usernames) order by username").setParameterList("usernames", Collections2.transform(usernames, FORMAT_USERNAME::apply));
        return ImmutableSet.copyOf((Collection)query.list());
    }

    public InternalServiceUser findServiceUserByName(@Nonnull String username, boolean inactive) {
        Criteria criteria = this.session().createCriteria(InternalServiceUser.class).add((Criterion)Restrictions.eq((String)FIELD_USERNAME, (Object)username));
        if (!inactive) {
            criteria.add((Criterion)Restrictions.eq((String)FIELD_ACTIVE, (Object)true));
        }
        return (InternalServiceUser)criteria.uniqueResult();
    }

    @Nonnull
    public Page<InternalServiceUser> findServiceUsersByName(String displayName, @Nonnull PageRequest pageRequest) {
        Query query;
        if (StringUtils.isBlank((CharSequence)displayName)) {
            query = this.session().createQuery("from InternalServiceUser where active = true order by displayName");
        } else {
            query = this.session().createQuery("from InternalServiceUser where active = true and lower(displayName) like :displayName order by displayName");
            query.setParameter(FIELD_DISPLAY_NAME, (Object)("%" + IdentifierUtils.toLowerCase((String)displayName) + "%"));
        }
        return PageUtils.asPageOf(InternalServiceUser.class, this.pageQuery(query, pageRequest));
    }

    public InternalServiceUser findServiceUserBySlug(@Nonnull String slug) {
        return (InternalServiceUser)this.session().createQuery("from InternalServiceUser where slug = :slug and active = true").setParameter(FIELD_SLUG, (Object)slug).uniqueResult();
    }

    @Nonnull
    public Page<InternalNormalUser> findByDeletedDateEarlierThan(@Nonnull Date date, @Nonnull PageRequest pageRequest) {
        Query query = this.session().createQuery("from InternalNormalUser where deletedDate is not null and deletedDate < :deletedDate order by username").setParameter(FIELD_DELETED_DATE, (Object)date);
        return PageUtils.asPageOf(InternalNormalUser.class, this.pageQuery(query, pageRequest));
    }

    public InternalNormalUser loadUser(@Nonnull User user) {
        Object[] result = (Object[])this.session().createQuery("select id, slug, locale from InternalNormalUser where username = :username").setParameter(FIELD_USERNAME, (Object)FORMAT_USERNAME.apply(user.getName())).uniqueResult();
        if (result == null) {
            return null;
        }
        int id = ((Number)result[0]).intValue();
        String slug = (String)result[1];
        Locale locale = (Locale)result[2];
        return ((InternalNormalUser.Builder)((InternalNormalUser.Builder)((InternalNormalUser.Builder)new InternalNormalUser.Builder().crowdUser(user).id(id)).locale(locale).name(user.getName())).slug(slug)).build();
    }

    @Nonnull
    public Set<InternalNormalUser> loadUsers(@Nonnull Iterable<User> users) {
        ImmutableMap usersByName = Maps.uniqueIndex(users, user -> FORMAT_USERNAME.apply(user.getName()));
        if (usersByName.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<InternalNormalUser> stashUsers = new HashSet<InternalNormalUser>(usersByName.size(), 1.0f);
        for (List usernamePartition : Iterables.partition(usersByName.keySet(), (int)100)) {
            List results = this.session().createQuery("select username, id, slug, locale from InternalNormalUser where username in :usernames").setParameterList("usernames", (Collection)usernamePartition).list();
            for (Object result : results) {
                Object[] columns = (Object[])result;
                stashUsers.add(((InternalNormalUser.Builder)((InternalNormalUser.Builder)((InternalNormalUser.Builder)new InternalNormalUser.Builder().crowdUser((User)usersByName.get(columns[0])).id(((Number)columns[1]).intValue())).slug((String)columns[2])).name((String)columns[0])).locale((Locale)columns[3]).build());
            }
        }
        return stashUsers;
    }

    public InternalNormalUser rename(@Nonnull String oldUsername, @Nonnull String newUsername) {
        InternalNormalUser user = this.findByName(oldUsername);
        if (user == null) {
            return null;
        }
        InternalNormalUser updated = this.update(((InternalNormalUser.Builder)((InternalNormalUser.Builder)user.copy().name(newUsername)).slug(this.generateUniqueSlugForUser(newUsername, user.getType(), (InternalApplicationUser)user))).build());
        return updated;
    }

    @Override
    public InternalServiceUser update(@Nonnull InternalServiceUser user) {
        return (InternalServiceUser)this.session().merge((Object)user);
    }

    @Nonnull
    public InternalNormalUser createFor(@Nonnull User crowdUser) {
        InternalNormalUser user = this.findByName(crowdUser.getName());
        if (user == null) {
            user = this.create(((InternalNormalUser.Builder)new InternalNormalUser.Builder().name(crowdUser.getName())).crowdUser(crowdUser).build());
            this.session().saveOrUpdate((Object)new InternalUserSettings.Builder().user((InternalApplicationUser)user).settings(USER_SETTINGS).build());
        } else if (user.getDeletedDate() != null) {
            this.update(user.copy().deletedDate(null).build());
        }
        return user;
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Collections.singleton(Order.asc((String)FIELD_USERNAME));
    }

    private String generateUniqueSlug(String username, UserType userType) {
        return this.generateUniqueSlugForUser(username, userType, null);
    }

    private String generateUniqueSlugForUser(String username, UserType userType, InternalApplicationUser user) {
        String initialSlug;
        String slug = initialSlug = InternalApplicationUser.slugify((String)username);
        boolean slugFound = false;
        for (int tries = 0; tries <= 10; ++tries) {
            if (this.isSlugFree(slug, userType, user)) {
                log.debug("{}: Using slug \"{}\"", (Object)username, (Object)slug);
                slugFound = true;
                break;
            }
            log.debug("{}: Collision detected for slug \"{}\"", (Object)username, (Object)slug);
            slug = initialSlug + tries;
        }
        if (!slugFound) {
            slug = InternalApplicationUser.generateSlug((SecureTokenGenerator)this.tokenGenerator);
            log.debug("{}: Using random token \"{}\" as slug", (Object)username, (Object)slug);
        }
        return slug;
    }

    private boolean isSlugFree(String slug, UserType userType, InternalApplicationUser user) {
        InternalServiceUser slugUser = userType == UserType.SERVICE ? this.findServiceUserBySlug(slug) : this.findBySlug(slug);
        return slugUser == null || user != null && slugUser.getId() == user.getId();
    }

    private String safeAppendSuffix(String username, int maxResultLength, String suffix) {
        return username.substring(0, Math.min(maxResultLength - suffix.length(), username.length())) + suffix;
    }

    private Class<? extends InternalApplicationUser> userClassForType(UserType userType) {
        return userType == UserType.NORMAL ? InternalNormalUser.class : InternalServiceUser.class;
    }

    private Order orderFor(UserType userType) {
        if (userType == UserType.NORMAL) {
            return this.getImplicitOrder().iterator().next();
        }
        return Order.asc((String)FIELD_DISPLAY_NAME);
    }
}

