/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.pull.PullRequestParticipantCriteria;
import com.atlassian.stash.internal.pull.PullRequestSearchCriteria;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.hibernate.Query;
import org.hibernate.Session;

public abstract class AbstractPullRequestQueryHelper {
    private final StringBuilder constraintBuilder = new StringBuilder();
    private final StringBuilder joinBuilder = new StringBuilder();
    private final Map<String, Object> queryParameters = Maps.newHashMap();
    private int participantIndex = 0;

    private AbstractPullRequestQueryHelper() {
    }

    public AbstractPullRequestQueryHelper(@Nonnull PullRequestSearchCriteria criteria) {
        this();
        this.setToRepositoryId(criteria.getToRepositoryId());
        this.setToRefIds(criteria.getToRefIds());
        this.setFromRepositoryId(criteria.getFromRepositoryId());
        this.setFromRefIds(criteria.getFromRefIds());
        this.setParticipants(criteria.getParticipants());
        this.setState(criteria.getState());
    }

    @Nonnull
    public Query build(Session session) {
        Query query = session.createQuery(this.toString());
        for (Map.Entry<String, Object> parameterEntry : this.queryParameters.entrySet()) {
            if (parameterEntry.getValue() instanceof Collection) {
                query.setParameterList(parameterEntry.getKey(), (Collection)parameterEntry.getValue());
                continue;
            }
            query.setParameter(parameterEntry.getKey(), parameterEntry.getValue());
        }
        return query;
    }

    private void setFromRefIds(Collection<String> fromRefIds) {
        if (fromRefIds != null && !fromRefIds.isEmpty()) {
            this.addConstraint("pr.fromRef.id in (:fromRefIds) ");
            this.queryParameters.put("fromRefIds", fromRefIds);
        }
    }

    private void setFromRepositoryId(Integer fromRepositoryId) {
        if (fromRepositoryId != null) {
            this.addConstraint("pr.fromRef.repository.id = :fromRepositoryId ");
            this.queryParameters.put("fromRepositoryId", fromRepositoryId);
        }
    }

    private void setParticipants(Iterable<PullRequestParticipantCriteria> participants) {
        for (PullRequestParticipantCriteria participant : participants) {
            this.addParticipant(participant.getUser(), participant.getRole(), participant.getStatuses());
        }
    }

    private void setState(PullRequestState pullRequestState) {
        if (pullRequestState != null) {
            this.addConstraint("pr.state = :state ");
            this.queryParameters.put("state", pullRequestState);
        }
    }

    private void setToRefIds(Collection<String> toRefIds) {
        if (toRefIds != null && !toRefIds.isEmpty()) {
            this.addConstraint("pr.toRef.id in (:toRefIds) ");
            this.queryParameters.put("toRefIds", toRefIds);
        }
    }

    private void setToRepositoryId(Integer toRepositoryId) {
        if (toRepositoryId != null) {
            this.addConstraint("pr.toRef.repository.id = :toRepositoryId ");
            this.queryParameters.put("toRepositoryId", toRepositoryId);
        }
    }

    String getConstraintString() {
        return this.constraintBuilder.toString();
    }

    String getJoinString() {
        return this.joinBuilder.toString();
    }

    protected void addConstraint(String constraint) {
        this.constraintBuilder.append(this.constraintBuilder.length() == 0 ? "WHERE " : "AND ");
        this.constraintBuilder.append(constraint);
    }

    private void addParticipant(ApplicationUser user, PullRequestRole role, Set<PullRequestParticipantStatus> statuses) {
        if (user != null) {
            String alias = "p" + this.participantIndex++;
            this.joinBuilder.append(String.format("JOIN pr.participants %1$s WITH %1$s.user.id = :%1$sUserId ", alias));
            this.queryParameters.put(alias + "UserId", user.getId());
            if (role != null) {
                this.joinBuilder.append(String.format("and %1$s.role = :%1$sRole ", alias));
                this.queryParameters.put(alias + "Role", role);
                if (PullRequestRole.REVIEWER.equals((Object)role) && !statuses.isEmpty()) {
                    this.joinBuilder.append(String.format("and %1$s.status in :%1$sStatus ", alias));
                    this.queryParameters.put(alias + "Status", statuses);
                }
            }
        }
    }

    public abstract String toString();
}

