/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.participant;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.participant.InternalParticipable;
import com.atlassian.stash.internal.participant.InternalParticipant;
import javax.annotation.Nonnull;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractHibernateParticipantDao<P extends InternalParticipant<P>>
extends AbstractHibernateDao<Long, P> {
    @Autowired
    protected AbstractHibernateParticipantDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    @Nonnull
    public P create(@Nonnull P participant) {
        this.session().save(participant);
        InternalParticipable entity = participant.getEntity();
        entity.addParticipant(participant);
        this.session().update((Object)entity);
        return participant;
    }

    @Override
    public void delete(@Nonnull P participant) {
        InternalParticipable entity = participant.getEntity();
        entity.removeParticipant(participant);
        this.session().update((Object)entity);
        this.session().delete(participant);
    }

    @Override
    public void deleteById(Long id) {
        InternalParticipant participant = (InternalParticipant)this.getById(id);
        if (participant != null) {
            this.delete((P)participant);
        }
    }

    @Override
    @Nonnull
    public P update(@Nonnull P participant) {
        return (P)((InternalParticipant)HibernateUtils.initialize(super.update(participant)));
    }
}

