/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jdbc;

import com.atlassian.bitbucket.util.ProxyUtils;
import com.atlassian.stash.internal.jdbc.ConnectionTracker;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;

public class ProxyingConnectionTracker
implements ConnectionTracker {
    private final ConcurrentMap<Connection, Thread> leasesByConnection;

    public ProxyingConnectionTracker(int maxConnections) {
        this.leasesByConnection = new ConcurrentHashMap<Connection, Thread>(maxConnections + maxConnections / 2, 0.75f, 3);
    }

    @Override
    public void forEach(@Nonnull BiConsumer<Connection, Thread> consumer) {
        this.leasesByConnection.forEach(consumer);
    }

    @Override
    public int getConnectionCount() {
        return this.leasesByConnection.size();
    }

    @Override
    @Nonnull
    public Connection register(@Nonnull Connection connection) {
        return (Connection)ProxyUtils.createProxy(Connection.class, (InvocationHandler)new ConnectionInvocationHandler(connection), (Class[])new Class[0]);
    }

    private class ConnectionInvocationHandler
    implements InvocationHandler {
        private final Connection delegate;

        public ConnectionInvocationHandler(Connection delegate) {
            this.delegate = delegate;
            ProxyingConnectionTracker.this.leasesByConnection.put(delegate, Thread.currentThread());
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object object = method.invoke((Object)this.delegate, args);
                return object;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if ("close".equals(method.getName())) {
                    ProxyingConnectionTracker.this.leasesByConnection.remove(this.delegate);
                }
            }
        }
    }
}

