/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import java.util.List;
import java.util.function.Predicate;
import org.hibernate.Criteria;
import org.hibernate.Query;

public class HibernatePageUtils
extends PageUtils {
    private HibernatePageUtils() {
    }

    public static <T> Page<T> pageCriteria(Criteria criteria, PageRequest request, Predicate<? super T> predicate) {
        return HibernatePageUtils.filterPages(new CriteriaPageProvider(criteria), predicate, (PageRequest)request);
    }

    public static <T> Page<T> pageCriteria(Criteria criteria, PageRequest pageRequest) {
        List values = criteria.setFirstResult(pageRequest.getStart()).setMaxResults(pageRequest.getLimit() + 1).list();
        return HibernatePageUtils.createPage((Iterable)values, (PageRequest)pageRequest);
    }

    public static <T> Page<T> pageQuery(Query query, PageRequest request, Predicate<? super T> predicate) {
        return HibernatePageUtils.filterPages(new QueryPageProvider(query), predicate, (PageRequest)request);
    }

    public static <T> Page<T> pageQuery(Query query, PageRequest pageRequest) {
        List values = query.setFirstResult(pageRequest.getStart()).setMaxResults(pageRequest.getLimit() + 1).list();
        return HibernatePageUtils.createPage((Iterable)values, (PageRequest)pageRequest);
    }

    private static class QueryPageProvider<T>
    implements PageProvider<T> {
        private final Query query;

        public QueryPageProvider(Query query) {
            this.query = query;
        }

        public Page<T> get(PageRequest request) {
            return HibernatePageUtils.pageQuery(this.query, request);
        }
    }

    private static class CriteriaPageProvider<T>
    implements PageProvider<T> {
        private final Criteria criteria;

        public CriteriaPageProvider(Criteria criteria) {
            this.criteria = criteria;
        }

        public Page<T> get(PageRequest request) {
            return HibernatePageUtils.pageCriteria(this.criteria, request);
        }
    }
}

